/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.transaction.AbstractSingleResourceTransaction;
import org.mule.runtime.core.internal.transaction.xa.IllegalTransactionStateException;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;

public class ExtensionTransaction
extends AbstractSingleResourceTransaction {
    private Optional<ExtensionTransactionalResource> boundResource = Optional.empty();

    public ExtensionTransaction(String applicationName, NotificationDispatcher notificationFirer) {
        super(applicationName, notificationFirer);
    }

    @Override
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof ExtensionTransactionKey) || !(resource instanceof ExtensionTransactionalResource)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources(String.format("%s/%s", ExtensionTransactionKey.class.getName(), ExtensionTransactionalResource.class.getName())));
        }
        ExtensionTransactionalResource txResource = (ExtensionTransactionalResource)resource;
        this.boundResource = Optional.of(txResource);
        super.bindResource(key, resource);
        this.doBegin();
    }

    @Override
    public boolean hasResource(Object key) {
        return this.key != null && this.key.equals(key);
    }

    @Override
    public Object getResource(Object key) {
        return Objects.equals(this.key, key) ? this.resource : null;
    }

    @Override
    protected void doCommit() throws TransactionException {
        if (this.boundResource.isPresent()) {
            try {
                this.boundResource.get().commit();
            }
            catch (Exception e) {
                throw new TransactionException(e);
            }
        }
    }

    @Override
    protected void doRollback() throws TransactionException {
        if (this.boundResource.isPresent()) {
            try {
                this.boundResource.get().rollback();
            }
            catch (Exception e) {
                throw new TransactionException(e);
            }
        }
    }

    @Override
    protected Class getKeyType() {
        return ExtensionTransactionKey.class;
    }

    @Override
    protected Class getResourceType() {
        return ExtensionTransactionalResource.class;
    }

    @Override
    protected void doBegin() throws TransactionException {
        try {
            if (this.boundResource.isPresent()) {
                this.boundResource.get().begin();
            }
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }
}

