/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.store;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.sdk.api.store.ObjectStore;

public class SdkObjectStoreAdapter<T extends Serializable>
implements ObjectStore<T> {
    private final org.mule.runtime.api.store.ObjectStore delegate;

    SdkObjectStoreAdapter(org.mule.runtime.api.store.ObjectStore<T> delegate) {
        this.delegate = delegate;
    }

    public static <T extends Serializable> ObjectStore<T> from(Object value) {
        Preconditions.checkArgument(value != null, "Cannot adapt null value");
        if (value instanceof ObjectStore) {
            return (ObjectStore)value;
        }
        if (value instanceof org.mule.runtime.api.store.ObjectStore) {
            return new SdkObjectStoreAdapter<T>((org.mule.runtime.api.store.ObjectStore)value);
        }
        throw new IllegalArgumentException(String.format("Value of class '%s' is neither a '%s' nor a '%s'", value.getClass().getName(), ObjectStore.class.getName(), org.mule.runtime.api.store.ObjectStore.class.getName()));
    }

    @Override
    public boolean contains(String key) throws ObjectStoreException {
        return this.delegate.contains(key);
    }

    @Override
    public void store(String key, T value) throws ObjectStoreException {
        this.delegate.store(key, value);
    }

    @Override
    public T retrieve(String key) throws ObjectStoreException {
        return this.delegate.retrieve(key);
    }

    @Override
    public T remove(String key) throws ObjectStoreException {
        return this.delegate.remove(key);
    }

    @Override
    public boolean isPersistent() {
        return this.delegate.isPersistent();
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.delegate.clear();
    }

    @Override
    public void open() throws ObjectStoreException {
        this.delegate.open();
    }

    @Override
    public void close() throws ObjectStoreException {
        this.delegate.close();
    }

    @Override
    public List<String> allKeys() throws ObjectStoreException {
        return this.delegate.allKeys();
    }

    @Override
    public Map retrieveAll() throws ObjectStoreException {
        return this.delegate.retrieveAll();
    }
}

