/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.type.catalog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.runtime.api.el.ExpressionCompilationException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ArtifactTypeLoader;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.type.catalog.ExtensionModelToModuleDefinitionTransformer;
import org.mule.runtime.module.extension.internal.type.catalog.SpecialTypesTypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactTypeLoader
implements ArtifactTypeLoader,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactTypeLoader.class);
    private final TypeLoader primitivesTypeLoader = new PrimitiveTypesTypeLoader();
    private final TypeLoader specialTypesLoader = new SpecialTypesTypeLoader();
    private Map<String, Collection<ObjectType>> typesByExtension;
    private Map<String, Optional<MetadataType>> loadedTypes;
    private ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private Collection<ExtensionModel> extensionModels;
    private Collection<ModuleDefinition> moduleDefinitions;

    public DefaultArtifactTypeLoader() {
    }

    public DefaultArtifactTypeLoader(Collection<ExtensionModel> extensionModels, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        Objects.requireNonNull(extensionModels, "ExtensionModels collection cannot be null.");
        this.extensionModels = extensionModels;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    }

    @Inject
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionModels = extensionManager.getExtensions();
    }

    @Inject
    public void setExpressionLanguageMetadataService(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.extensionModels == null) {
            this.extensionModels = Collections.emptySet();
            LOGGER.warn("DefaultArtifactTypeLoader has been initialized with a null Collection of ExtensionModels");
        }
        this.typesByExtension = new HashMap<String, Collection<ObjectType>>();
        this.loadedTypes = new ConcurrentHashMap<String, Optional<MetadataType>>();
        for (ExtensionModel extensionModel : this.extensionModels) {
            String extensionPrefix = extensionModel.getXmlDslModel().getPrefix();
            this.typesByExtension.put(extensionPrefix, extensionModel.getTypes());
        }
        this.moduleDefinitions = DefaultArtifactTypeLoader.extensionModelsToModuleDefinitions(this.extensionModels);
    }

    private static Collection<ModuleDefinition> extensionModelsToModuleDefinitions(Collection<ExtensionModel> extensionModels) {
        ExtensionModelToModuleDefinitionTransformer toModule = new ExtensionModelToModuleDefinitionTransformer();
        return extensionModels.stream().map(toModule).collect(Collectors.toSet());
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        return this.loadedTypes.computeIfAbsent(typeIdentifier, this::doLoad);
    }

    private Optional<MetadataType> doLoad(String typeIdentifier) {
        Optional<MetadataType> primitive = this.primitivesTypeLoader.load(typeIdentifier);
        if (primitive.isPresent()) {
            return primitive;
        }
        Optional<MetadataType> special = this.specialTypesLoader.load(typeIdentifier);
        if (special.isPresent()) {
            return special;
        }
        Optional<MetadataType> parsed = this.parseType(typeIdentifier);
        if (parsed.isPresent()) {
            return parsed;
        }
        return this.loadFromExpressionLanguageMetadataService(typeIdentifier);
    }

    private Optional<MetadataType> loadFromExpressionLanguageMetadataService(String typeExpression) {
        if (this.expressionLanguageMetadataService == null) {
            LOGGER.warn("Couldn't evaluate type expression '{}' because the ExpressionLanguageMetadataService wasn't correctly injected", (Object)typeExpression);
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.expressionLanguageMetadataService.evaluateTypeExpression(typeExpression, this.moduleDefinitions));
        }
        catch (ExpressionCompilationException exception) {
            LOGGER.error("Failed to evaluate type expression '{}'", (Object)typeExpression, (Object)exception);
            return Optional.empty();
        }
    }

    private Optional<MetadataType> parseType(String typeIdentifier) {
        if (!typeIdentifier.contains(":")) {
            return Optional.empty();
        }
        int separatorIndex = typeIdentifier.indexOf(":");
        String extensionIdentifier = typeIdentifier.substring(0, separatorIndex);
        String typeIdOrAlias = typeIdentifier.substring(separatorIndex + 1);
        if (this.typesByExtension.containsKey(extensionIdentifier)) {
            HashSet<MetadataType> typesWithTypeIdentifierAsAlias = new HashSet<MetadataType>();
            for (MetadataType metadataType2 : this.typesByExtension.get(extensionIdentifier)) {
                Optional<String> extensionTypeTypeId = MetadataTypeUtils.getTypeId(metadataType2);
                if (extensionTypeTypeId.isPresent() && extensionTypeTypeId.get().equals(typeIdOrAlias)) {
                    return Optional.of(metadataType2);
                }
                String extensionTypeAlias = ExtensionMetadataTypeUtils.getAlias(metadataType2);
                if (extensionTypeAlias == null || !extensionTypeAlias.equals(typeIdOrAlias)) continue;
                typesWithTypeIdentifierAsAlias.add(metadataType2);
            }
            if (typesWithTypeIdentifierAsAlias.size() == 1) {
                return Optional.of((MetadataType)typesWithTypeIdentifierAsAlias.iterator().next());
            }
            if (typesWithTypeIdentifierAsAlias.size() > 1) {
                throw new IllegalArgumentException(String.format("No type with identifier [%s] and more that one with that alias. Use typeId to remove ambiguity [%s]", typeIdOrAlias, typesWithTypeIdentifierAsAlias.stream().map(metadataType -> MetadataTypeUtils.getTypeId(metadataType).orElse("")).collect(Collectors.joining(", "))));
            }
        }
        return Optional.empty();
    }
}

