/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.type.catalog;

import java.util.function.Function;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;

public class ExtensionModelToModuleDefinitionTransformer
implements Function<ExtensionModel, ModuleDefinition> {
    @Override
    public ModuleDefinition apply(ExtensionModel extensionModel) {
        ModuleDefinition.Builder moduleDefBuilder = ModuleDefinition.builder(ExtensionModelToModuleDefinitionTransformer.getPrefix(extensionModel));
        extensionModel.getFunctionModels().forEach(functionModel -> ExtensionModelToModuleDefinitionTransformer.addFunction(functionModel, moduleDefBuilder));
        extensionModel.getTypes().forEach(type -> ExtensionModelToModuleDefinitionTransformer.addType(type, moduleDefBuilder));
        return moduleDefBuilder.build();
    }

    private static String getPrefix(ExtensionModel extensionModel) {
        return extensionModel.getXmlDslModel().getPrefix();
    }

    private static void addType(MetadataType type, ModuleDefinition.Builder moduleDefBuilder) {
        moduleDefBuilder.addType(type);
    }

    private static void addFunction(FunctionModel functionModel, ModuleDefinition.Builder moduleDefBuilder) {
        FunctionTypeBuilder functionTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).functionType();
        functionModel.getAllParameterModels().forEach(parameterModel -> {
            if (parameterModel.isRequired()) {
                functionTypeBuilder.addOptionalParameterOf(parameterModel.getName(), parameterModel.getType());
            } else {
                functionTypeBuilder.addParameterOf(parameterModel.getName(), parameterModel.getType());
            }
        });
        functionTypeBuilder.returnType(functionModel.getOutput().getType());
        moduleDefBuilder.addElement(functionModel.getName(), functionTypeBuilder.build());
    }
}

