/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.repository.internal;

import java.io.File;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.exception.BundleDependencyNotFoundException;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.repository.api.BundleNotFoundException;
import org.mule.runtime.module.repository.api.RepositoryConnectionException;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceDisabledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRepositoryService
implements RepositoryService,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryService.class);
    private final MavenClient mavenClient;

    public DefaultRepositoryService(MavenClient mavenClient) {
        this.mavenClient = mavenClient;
    }

    @Override
    public File lookupBundle(BundleDependency bundleDependency) {
        try {
            if (this.mavenClient.getMavenConfiguration().getMavenRemoteRepositories().isEmpty()) {
                throw new RepositoryServiceDisabledException("Repository service has not been configured so it's disabled. To enable it you must configure the set of repositories to use using the system property: mule.repository.repositories");
            }
            org.mule.maven.pom.parser.api.model.BundleDependency resolvedBundleDependency = this.mavenClient.resolveBundleDescriptor(this.muleToMavenDescriptor(bundleDependency.getDescriptor()));
            return new File(resolvedBundleDependency.getBundleUri().getPath());
        }
        catch (BundleDependencyNotFoundException e) {
            throw new BundleNotFoundException(e);
        }
        catch (BundleDependenciesResolutionException e) {
            throw new RepositoryConnectionException("There was a problem connecting to one of the repositories", e);
        }
    }

    private BundleDescriptor muleToMavenDescriptor(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor) {
        return new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setVersion(bundleDescriptor.getVersion()).setBaseVersion(bundleDescriptor.getBaseVersion() != null ? bundleDescriptor.getBaseVersion() : bundleDescriptor.getVersion()).setType(bundleDescriptor.getType()).setClassifier(bundleDescriptor.getClassifier().orElse(null)).build();
    }

    @Override
    public void dispose() {
        try {
            this.mavenClient.close();
        }
        catch (Exception e) {
            LOGGER.error("Error while disposing 'mavenClient'", (Throwable)e);
        }
    }
}

