/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.common.watcher;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingConfigurationFileWatcher
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracingConfigurationFileWatcher.class);
    public final long DEFAULT_DELAY;
    private final String filename;
    private final Runnable doOnChange;
    protected long delay;
    private final File file;
    private long lastModified;
    private boolean warnedAlready;

    public TracingConfigurationFileWatcher(String filename, Runnable doOnChange) {
        super("FileSpanExporterConfigurationWatcher");
        this.delay = this.DEFAULT_DELAY = Long.getLong("mule.openTelemetry.tracer.exporter.configurationFileWatcherDelay", 60000L).longValue();
        this.filename = filename;
        this.file = new File(filename);
        this.doOnChange = doOnChange;
        this.lastModified = this.file.lastModified();
        this.setDaemon(true);
    }

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException var4) {
            LOGGER.warn("The tracing config file " + this.filename + " was possibly removed.");
            this.interrupt();
            return;
        }
        if (fileExists) {
            long fileLastMod = this.file.lastModified();
            if (fileLastMod > this.lastModified) {
                this.lastModified = fileLastMod;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LOGGER.warn("Configuration for file exporter was not found. It was possibly removed.");
            this.warnedAlready = true;
        }
    }

    @Override
    public void run() {
        while (!TracingConfigurationFileWatcher.interrupted()) {
            try {
                this.checkAndConfigure();
                TracingConfigurationFileWatcher.sleep(this.delay);
            }
            catch (InterruptedException var2) {
                return;
            }
        }
    }

    private void doOnChange() {
        this.doOnChange.run();
    }
}

