/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.impl.SpanInfoUtils;
import org.mule.runtime.tracer.impl.span.command.EventContextAddAttributeCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextAddAttributesCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextEndSpanCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextGetDistributedTraceContextMapCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextInjectDistributedTraceContextCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextRecordErrorCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextSetCurrentSpanNameCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextStartSpanCommand;
import org.mule.runtime.tracer.impl.span.factory.EventSpanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreEventTracer
implements EventTracer<CoreEvent>,
Initialisable {
    private final boolean propagateTracingExceptions = Boolean.getBoolean("mule.enable.propagation.of.exceptions.in.tracing");
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreEventTracer.class);
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_TRACER_START_COMMAND_MESSAGE = "Error on executing core event tracer start command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_TRACER_END_COMMAND_MESSAGE = "Error on executing core event tracer end command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_TRACER_INJECT_DISTRIBUTED_TRACE_CONTEXT_COMMAND_MESSAGE = "Error on executing core event tracer inject distributed trace context command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_TRACER_RECORD_ERROR_COMMAND_MESSAGE = "Error on executing core event tracer record error command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_TRACER_ADD_ATTRIBUTES_COMMAND_MESSAGE = "Error on executing core event tracer add attributes command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_TRACER_ADD_ATTRIBUTE_COMMAND_MESSAGE = "Error on executing core event tracer add attribute command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_SET_CURRENT_SPAN_COMMAND_MESSAGE = "Error on executing core event set current span command";
    public static final String ERROR_ON_EXECUTING_CORE_EVENT_GET_DISTRIBUTED_CONTEXT_SPAN_COMMAND_MESSAGE = "Error on executing core event get distributed context span command";
    private final FeatureFlaggingService featureFlaggingService;
    private final EventSpanFactory eventSpanFactory;
    private EventContextStartSpanCommand startCommand;
    private EventContextEndSpanCommand endCommand;
    private EventContextInjectDistributedTraceContextCommand injectDistributedTraceContextCommand;
    private EventContextRecordErrorCommand recordErrorAtCurrentSpanCommand;
    private EventContextAddAttributesCommand eventContextAddSpanAttributesCommand;
    private EventContextAddAttributeCommand eventContextAddSpanAttributeCommand;
    private EventContextSetCurrentSpanNameCommand eventContextSetCurrentSpanNameCommand;
    private EventContextGetDistributedTraceContextMapCommand eventContextGetDistributedTraceContextMap;

    public CoreEventTracer(FeatureFlaggingService featureFlaggingService, EventSpanFactory eventSpanFactory) {
        this.featureFlaggingService = featureFlaggingService;
        this.eventSpanFactory = eventSpanFactory;
    }

    @Override
    public Optional<Span> startSpan(CoreEvent coreEvent, InitialSpanInfo spanCustomizationInfo) {
        return this.startSpan(coreEvent, spanCustomizationInfo, Assertion.SUCCESSFUL_ASSERTION);
    }

    @Override
    public Optional<Span> startSpan(CoreEvent coreEvent, InitialSpanInfo initialSpanInfo, Assertion assertion) {
        return (Optional)this.startCommand.execute(coreEvent.getContext(), SpanInfoUtils.enrichInitialSpanInfo(initialSpanInfo, coreEvent), assertion);
    }

    @Override
    public void endCurrentSpan(CoreEvent coreEvent) {
        this.endCurrentSpan(coreEvent, Assertion.SUCCESSFUL_ASSERTION);
    }

    @Override
    public void endCurrentSpan(CoreEvent coreEvent, Assertion condition) {
        this.endCommand.execute(coreEvent.getContext(), condition);
    }

    @Override
    public void injectDistributedTraceContext(EventContext eventContext, DistributedTraceContextGetter distributedTraceContextGetter) {
        if (!distributedTraceContextGetter.isEmptyDistributedTraceContext()) {
            this.injectDistributedTraceContextCommand.execute(eventContext, distributedTraceContextGetter);
        }
    }

    @Override
    public void recordErrorAtCurrentSpan(CoreEvent coreEvent, Supplier<Error> errorSupplier, boolean isErrorEscapingCurrentSpan) {
        this.recordErrorAtCurrentSpanCommand.execute(coreEvent, errorSupplier, isErrorEscapingCurrentSpan);
    }

    @Override
    public void setCurrentSpanName(CoreEvent coreEvent, String name) {
        this.eventContextSetCurrentSpanNameCommand.execute(coreEvent.getContext(), name);
    }

    @Override
    public void addCurrentSpanAttribute(CoreEvent coreEvent, String key, String value) {
        this.eventContextAddSpanAttributeCommand.execute(coreEvent.getContext(), key, value);
    }

    @Override
    public void addCurrentSpanAttributes(CoreEvent coreEvent, Map<String, String> attributes) {
        this.eventContextAddSpanAttributesCommand.execute(coreEvent.getContext(), attributes);
    }

    @Override
    public SpanSnifferManager getSpanSnifferManager() {
        return this.eventSpanFactory.getSpanSnifferManager();
    }

    @Override
    public Map<String, String> getDistributedTraceContextMap(CoreEvent event) {
        return (Map)this.eventContextGetDistributedTraceContextMap.execute(event.getContext());
    }

    @Override
    public void initialise() throws InitialisationException {
        boolean enablePutTraceIdAndSpanIdInMdc = this.featureFlaggingService.isEnabled(MuleRuntimeFeature.PUT_TRACE_ID_AND_SPAN_ID_IN_MDC);
        this.startCommand = EventContextStartSpanCommand.getEventContextStartSpanCommandFrom(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_TRACER_START_COMMAND_MESSAGE, this.propagateTracingExceptions, this.eventSpanFactory, enablePutTraceIdAndSpanIdInMdc);
        this.endCommand = EventContextEndSpanCommand.getEventContextEndSpanCommandFrom(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_TRACER_END_COMMAND_MESSAGE, this.propagateTracingExceptions, enablePutTraceIdAndSpanIdInMdc);
        this.injectDistributedTraceContextCommand = EventContextInjectDistributedTraceContextCommand.getEventContextInjectDistributedTraceContextCommand(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_TRACER_INJECT_DISTRIBUTED_TRACE_CONTEXT_COMMAND_MESSAGE, false);
        this.recordErrorAtCurrentSpanCommand = EventContextRecordErrorCommand.getEventContextRecordErrorCommand(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_TRACER_RECORD_ERROR_COMMAND_MESSAGE, this.propagateTracingExceptions);
        this.eventContextAddSpanAttributesCommand = EventContextAddAttributesCommand.getEventContextAddAttributesCommand(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_TRACER_ADD_ATTRIBUTES_COMMAND_MESSAGE, this.propagateTracingExceptions);
        this.eventContextAddSpanAttributeCommand = EventContextAddAttributeCommand.getEventContextAddAttributeCommand(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_TRACER_ADD_ATTRIBUTE_COMMAND_MESSAGE, this.propagateTracingExceptions);
        this.eventContextSetCurrentSpanNameCommand = EventContextSetCurrentSpanNameCommand.getEventContextSetCurrentSpanNameCommand(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_SET_CURRENT_SPAN_COMMAND_MESSAGE, this.propagateTracingExceptions);
        this.eventContextGetDistributedTraceContextMap = EventContextGetDistributedTraceContextMapCommand.getEventContextGetDistributedTraceContextMapCommand(LOGGER, ERROR_ON_EXECUTING_CORE_EVENT_GET_DISTRIBUTED_CONTEXT_SPAN_COMMAND_MESSAGE, this.propagateTracingExceptions);
    }
}

