/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.mule.api.MuleException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;

public abstract class DSLException
extends RuntimeException {
    private static final long serialVersionUID = 2340975800429988301L;
    private final Map info = new HashMap();
    private int errorCode = -1;
    private String message = null;
    private Message i18nMessage;

    public DSLException(Message message) {
        this.setMessage(message);
    }

    public DSLException(String message) {
        this.setMessage(message);
    }

    public DSLException(Message message, Throwable cause) {
        super(ExceptionHelper.unwrap((Throwable)cause));
        this.setMessage(message);
    }

    public DSLException(String message, Throwable cause) {
        super(ExceptionHelper.unwrap((Throwable)cause));
        this.setMessage(message);
    }

    public DSLException(Throwable cause) {
        super(ExceptionHelper.unwrap((Throwable)cause));
        if (cause != null) {
            this.setMessage(MessageFactory.createStaticMessage((String)(cause.getMessage() + " (" + cause.getClass().getName() + ")")));
        } else {
            this.initialise();
        }
    }

    protected void setMessage(Message message) {
        this.initialise();
        this.message = message.getMessage();
        this.i18nMessage = message;
    }

    protected void setMessage(String message) {
        this.initialise();
        this.message = message;
        if (this.i18nMessage == null) {
            this.i18nMessage = MessageFactory.createStaticMessage((String)message);
        }
    }

    public int getExceptionCode() {
        return this.errorCode;
    }

    public Message getI18nMessage() {
        return this.i18nMessage;
    }

    public int getMessageCode() {
        return this.i18nMessage == null ? 0 : this.i18nMessage.getCode();
    }

    public void addInfo(String name, Object info) {
        this.info.put(name, info);
    }

    protected void appendMessage(String s) {
        this.message = this.message + s;
    }

    protected void prependMessage(String s) {
        this.message = this.message + ". " + s;
    }

    protected void setExceptionCode(int code) {
        this.errorCode = code;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    protected void initialise() {
        this.setExceptionCode(ExceptionHelper.getErrorCode(this.getClass()));
        String javadoc = ExceptionHelper.getJavaDocUrl(this.getClass());
        String doc = ExceptionHelper.getDocUrl(this.getClass());
        if (javadoc != null) {
            this.info.put("JavaDoc", javadoc);
        }
        if (doc != null) {
            this.info.put("Other Doc", doc);
        }
    }

    public String getDetailedMessage() {
        if (DefaultMuleConfiguration.verboseExceptions) {
            return this.getVerboseMessage();
        }
        return this.getSummaryMessage();
    }

    public String getVerboseMessage() {
        MuleException e = ExceptionHelper.getRootMuleException((Throwable)this);
        if (!e.equals((Object)this)) {
            return this.getMessage();
        }
        StringBuffer buf = new StringBuffer(1024);
        buf.append(SystemUtils.LINE_SEPARATOR).append(org.mule.util.StringUtils.repeat((char)'*', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Message               : ").append(this.message).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Type                  : ").append(this.getClass().getName()).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Code                  : ").append("MULE_ERROR-").append(this.getExceptionCode() + this.getMessageCode()).append(SystemUtils.LINE_SEPARATOR);
        Map info = ExceptionHelper.getExceptionInfo((Throwable)this);
        for (String s : info.keySet()) {
            int pad = 22 - s.length();
            buf.append(s);
            if (pad > 0) {
                buf.append(org.mule.util.StringUtils.repeat((char)' ', (int)pad));
            }
            buf.append(": ");
            buf.append(info.get(s)).append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append(org.mule.util.StringUtils.repeat((char)'*', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(CoreMessages.exceptionStackIs()).append(SystemUtils.LINE_SEPARATOR);
        buf.append(StringUtils.abbreviate((String)ExceptionHelper.getExceptionStack((Throwable)this), (int)5000));
        buf.append(org.mule.util.StringUtils.repeat((char)'*', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(CoreMessages.rootStackTrace()).append(SystemUtils.LINE_SEPARATOR);
        Throwable root = ExceptionHelper.getRootException((Throwable)this);
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        root.printStackTrace(p);
        buf.append(StringUtils.abbreviate((String)w.toString(), (int)5000)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(org.mule.util.StringUtils.repeat((char)'*', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        return buf.toString();
    }

    public String getSummaryMessage() {
        MuleException e = ExceptionHelper.getRootMuleException((Throwable)this);
        if (!e.equals((Object)this)) {
            return this.getMessage();
        }
        StringBuffer buf = new StringBuffer(1024);
        buf.append(SystemUtils.LINE_SEPARATOR).append(org.mule.util.StringUtils.repeat((char)'*', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Message               : ").append(this.message).append(SystemUtils.LINE_SEPARATOR);
        buf.append("Code                  : ").append("MULE_ERROR-").append(this.getExceptionCode() + this.getMessageCode()).append(SystemUtils.LINE_SEPARATOR);
        buf.append(org.mule.util.StringUtils.repeat((char)'-', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(CoreMessages.exceptionStackIs()).append(SystemUtils.LINE_SEPARATOR);
        buf.append(StringUtils.abbreviate((String)ExceptionHelper.getExceptionStack((Throwable)this), (int)5000));
        buf.append(org.mule.util.StringUtils.repeat((char)'-', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        buf.append(CoreMessages.rootStackTrace()).append(SystemUtils.LINE_SEPARATOR);
        Throwable root = ExceptionHelper.getRootException((Throwable)this);
        Throwable rootSummary = ExceptionHelper.summarise((Throwable)root, (int)3);
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        rootSummary.printStackTrace(p);
        buf.append(StringUtils.abbreviate((String)w.toString(), (int)5000));
        buf.append("    + " + root.getStackTrace().length + " more (set debug level logging or '-Dmule.verbose.exceptions=true' for everything)").append(SystemUtils.LINE_SEPARATOR);
        buf.append(org.mule.util.StringUtils.repeat((char)'*', (int)80)).append(SystemUtils.LINE_SEPARATOR);
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DSLException)) {
            return false;
        }
        DSLException exception = (DSLException)o;
        if (this.errorCode != exception.errorCode) {
            return false;
        }
        if (this.i18nMessage != null ? !this.i18nMessage.equals(exception.i18nMessage) : exception.i18nMessage != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(exception.message) : exception.message != null);
    }

    public int hashCode() {
        int result = this.errorCode;
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 29 * result + (this.i18nMessage != null ? this.i18nMessage.hashCode() : 0);
        return result;
    }

    public Map getInfo() {
        return this.info;
    }
}

