/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.util;

public final class DefaultValueConverter {
    private DefaultValueConverter() {
    }

    public static <T> T valueOf(Class<T> type, String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (T)Byte.valueOf(s);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (T)Short.valueOf(s);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(s);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(s);
        }
        if (Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(s);
        }
        if (Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(s);
        }
        if (Character.class.isAssignableFrom(type)) {
            if (s.length() > 0) {
                return (T)new Character(s.charAt(0));
            }
            return (T)new Character('\u0000');
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(s);
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)s;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, s);
        }
        return null;
    }
}

