/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.mule.config.dsl.IOException;
import org.mule.config.dsl.util.Preconditions;
import org.mule.util.IOUtils;

public class FileRefBuilder {
    private final File file;
    private InputStream content = null;
    private String stringContent = null;

    public FileRefBuilder(String path) throws IllegalArgumentException {
        Preconditions.checkNotEmpty(path, "path");
        this.file = new File(path);
    }

    public FileRefBuilder(File file) throws NullPointerException {
        this.file = Preconditions.checkNotNull(file, "file");
    }

    public InputStream get() throws IOException {
        if (this.content == null) {
            if (!this.file.exists()) {
                throw new IOException("File not found.");
            }
            if (!this.file.isFile()) {
                throw new IOException("It's not a file.");
            }
            if (!this.file.canRead()) {
                throw new IOException("Can't read file.");
            }
            try {
                this.content = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new IOException("File not found.", (Throwable)e);
            }
        }
        return this.content;
    }

    public String getAsString() throws IOException {
        if (this.stringContent == null) {
            this.stringContent = IOUtils.toString((InputStream)this.get());
        }
        return this.stringContent;
    }
}

