/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.util;

import org.apache.commons.lang.StringUtils;

public class Preconditions {
    private Preconditions() {
    }

    public static void checkState(boolean expression, Object errorMessage) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) throws NullPointerException {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static String checkNotEmpty(String reference, Object errorMessage) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)reference)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T[] checkContentsNotNull(T[] reference, Object errorMessage) throws NullPointerException {
        Preconditions.checkNotNull(reference, errorMessage);
        for (T element : reference) {
            Preconditions.checkNotNull(element, errorMessage);
        }
        return reference;
    }
}

