/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.ErrorHandler;
import com.anypoint.df.edi.lexical.LexicalDataException;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class LexerBase {
    protected final Logger logger = Logger.getLogger(this.getClass());
    final InputStream stream;
    boolean[] allowedChars;
    Reader reader;
    char dataSeparator;
    int repetitionSeparator;
    char componentSeparator;
    int subCompSeparator;
    int releaseIndicator;
    char segmentTerminator;
    int substitutionChar;
    int altDecimalMark;
    int groupCount;
    int segmentNumber;
    int elementNumber;
    private ErrorHandler errorHandler;
    private int repetitionNumber;
    private int componentNumber;
    private int subCompNumber;
    private EdiConstants.ItemType currentType;
    private String token;
    private EdiConstants.ItemType nextType;
    private String peekToken;
    private EdiConstants.ItemType peekType;

    public LexerBase(InputStream is) {
        this.stream = is;
        this.repetitionSeparator = -1;
        this.subCompSeparator = -1;
        this.releaseIndicator = -1;
        this.substitutionChar = -1;
        this.altDecimalMark = -1;
    }

    public abstract Object init(Map<String, Object> var1) throws LexicalException;

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable t) {}
        } else {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void readArray(byte[] byts, int from) throws IOException {
        int count;
        for (int offset = from; byts.length > offset; offset += count) {
            count = this.stream.read(byts, offset, byts.length - offset);
            if (count > 0) continue;
            throw new IOException("Required data missing from message");
        }
    }

    byte[] readBytes(int num) throws IOException {
        byte[] byts = new byte[num];
        this.readArray(byts, 0);
        return byts;
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public char getDataSeparator() {
        return this.dataSeparator;
    }

    public int getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public char getComponentSeparator() {
        return this.componentSeparator;
    }

    public int getReleaseIndicator() {
        return this.releaseIndicator;
    }

    public char getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public int getRepetitionNumber() {
        return this.repetitionNumber;
    }

    public int getComponentNumber() {
        return this.componentNumber;
    }

    public int getSubComponentNumber() {
        return this.subCompNumber;
    }

    public String token() {
        return this.token;
    }

    public EdiConstants.ItemType currentType() {
        return this.currentType;
    }

    public EdiConstants.ItemType nextType() {
        return this.nextType;
    }

    void handleError(EdiConstants.DataType typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber + 1);
        if (this.repetitionNumber > 0) {
            position = "repetition " + Integer.toString(this.repetitionNumber + 1) + " of " + position;
        }
        switch (this.currentType) {
            case SUB_COMPONENT: 
            case COMPONENT: {
                position = "component " + Integer.toString(this.componentNumber + 1) + " of " + position;
                if (this.currentType != EdiConstants.ItemType.SUB_COMPONENT) break;
                position = "subcomponent " + Integer.toString(this.subCompNumber + 1) + " of " + position;
            }
        }
        String text = err.text() + " for data type " + typ.code() + " at " + position + ": '" + this.token + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(this, typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error((Object)("Unrecoverable lexer error " + text));
            } else {
                this.logger.info((Object)("Recoverable lexer error " + text));
            }
        }
    }

    public String peek() throws IOException {
        if (this.peekToken == null && this.peekType != EdiConstants.ItemType.END) {
            int value = this.reader.read();
            if (this.nextType == EdiConstants.ItemType.SEGMENT) {
                while (value == 10 || value == 13 || value == 32) {
                    value = this.reader.read();
                }
            }
            if (value < 0) {
                this.peekToken = "";
                this.peekType = EdiConstants.ItemType.END;
                return this.peekToken;
            }
            char chr = (char)value;
            StringBuilder builder = new StringBuilder();
            boolean escape = false;
            while (true) {
                if (escape) {
                    builder.append(chr);
                    escape = false;
                } else {
                    if (chr == this.subCompSeparator) {
                        this.peekType = EdiConstants.ItemType.SUB_COMPONENT;
                        break;
                    }
                    if (chr == this.componentSeparator) {
                        this.peekType = EdiConstants.ItemType.COMPONENT;
                        break;
                    }
                    if (chr == this.dataSeparator) {
                        this.peekType = EdiConstants.ItemType.DATA_ELEMENT;
                        break;
                    }
                    if (chr == this.segmentTerminator) {
                        this.peekType = EdiConstants.ItemType.SEGMENT;
                        break;
                    }
                    if (chr == this.repetitionSeparator) {
                        this.peekType = EdiConstants.ItemType.REPETITION;
                        break;
                    }
                    if (chr == this.releaseIndicator) {
                        escape = true;
                    } else {
                        if (value == -1) {
                            this.peekType = EdiConstants.ItemType.END;
                            break;
                        }
                        builder.append(chr);
                    }
                }
                value = this.reader.read();
                if (value < 0) {
                    throw new IOException("Unexpected end of file in data");
                }
                chr = (char)value;
            }
            this.peekToken = builder.length() > 0 ? builder.toString() : "";
        }
        return this.peekToken;
    }

    public String advance() throws IOException {
        this.peek();
        this.currentType = this.nextType;
        switch (this.currentType) {
            case DATA_ELEMENT: {
                ++this.elementNumber;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SEGMENT: {
                ++this.segmentNumber;
            }
            case END: {
                this.elementNumber = 0;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SUB_COMPONENT: {
                ++this.subCompNumber;
                break;
            }
            case COMPONENT: {
                ++this.componentNumber;
                break;
            }
            case REPETITION: {
                ++this.repetitionNumber;
                this.componentNumber = 0;
            }
        }
        this.token = this.peekToken;
        this.nextType = this.peekType;
        this.peekToken = null;
        this.peekType = null;
        return this.token;
    }

    String advance(EdiConstants.ItemType type) throws IOException {
        this.nextType = type;
        return this.advance();
    }

    public void checkLength(EdiConstants.DataType type, int length, int minl, int maxl) throws LexicalException {
        if (length < minl) {
            this.handleError(type, ErrorHandler.ErrorCondition.TOO_SHORT, "effective length " + length + " is less than " + minl);
        } else if (length > maxl) {
            this.handleError(type, ErrorHandler.ErrorCondition.TOO_LONG, "effective length " + length + " is greater than " + maxl);
        }
    }

    public void checkLength(EdiConstants.DataType type, int minl, int maxl) throws LexicalException {
        this.checkLength(type, this.token.length(), minl, maxl);
    }

    public String parseAlpha(int minl, int maxl) throws IOException {
        this.checkLength(EdiConstants.DataType.ALPHA, minl, maxl);
        String text = this.token;
        int lastns = -1;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') {
                this.handleError(EdiConstants.DataType.ALPHA, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
                continue;
            }
            if (chr == ' ') continue;
            lastns = i;
        }
        this.advance();
        return text.substring(0, lastns + 1);
    }

    public String parseAlphaNumeric(int minl, int maxl) throws IOException {
        this.checkLength(EdiConstants.DataType.ALPHANUMERIC, minl, maxl);
        String text = this.token;
        int lastns = -1;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (!(this.allowedChars == null || chr <= this.allowedChars.length && this.allowedChars[chr])) {
                this.handleError(EdiConstants.DataType.ALPHANUMERIC, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
                if (this.substitutionChar >= 0) {
                    text = text.replace(chr, (char)this.substitutionChar);
                }
            }
            if (chr == ' ') continue;
            lastns = i;
        }
        this.advance();
        return text.substring(0, lastns + 1);
    }

    public String parseId(int minl, int maxl) throws IOException {
        this.checkLength(EdiConstants.DataType.ID, minl, maxl);
        String text = this.token;
        int lastns = -1;
        boolean space = false;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (Character.isAlphabetic(chr) || chr >= '0' && chr <= '9') {
                if (space) {
                    this.handleError(EdiConstants.DataType.ID, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "embedded space not allowed");
                }
                lastns = i;
                continue;
            }
            if (chr == ' ') {
                space = true;
                continue;
            }
            this.handleError(EdiConstants.DataType.ID, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        this.advance();
        return text.substring(0, lastns + 1);
    }

    protected void checkInteger(int minl, int maxl) throws LexicalException {
        String text = this.token;
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') {
                ++length;
                continue;
            }
            if (i == 0 && chr == '-') continue;
            this.handleError(EdiConstants.DataType.INTEGER, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        this.checkLength(EdiConstants.DataType.INTEGER, length, minl, maxl);
    }

    public Integer parseInteger(int minl, int maxl) throws IOException {
        this.checkInteger(minl, maxl);
        String text = this.token;
        this.advance();
        return Integer.valueOf(text);
    }

    public Integer parseSeqId() throws IOException {
        String text = this.token;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.handleError(EdiConstants.DataType.INTEGER, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        this.checkLength(EdiConstants.DataType.INTEGER, text.length(), 1, 4);
        this.advance();
        return Integer.valueOf(text);
    }

    public BigInteger parseBigInteger(int minl, int maxl) throws IOException {
        this.checkInteger(minl, maxl);
        String text = this.token;
        this.advance();
        return new BigInteger(text);
    }

    public BigDecimal parseNumber(int minl, int maxl) throws IOException {
        String text = this.token;
        int length = 0;
        boolean decimal = false;
        int exponent = -1;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') {
                ++length;
                continue;
            }
            if (!(decimal || chr != '.' && chr != this.altDecimalMark)) {
                decimal = true;
                if (chr != this.altDecimalMark) continue;
                text = text.replace((char)this.altDecimalMark, '.');
                continue;
            }
            if (exponent < 0 && (chr == 'E' || chr == 'e')) {
                exponent = i;
                continue;
            }
            if ((i == 0 || i == exponent + 1) && chr == '-') continue;
            this.handleError(EdiConstants.DataType.REAL, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed or wrong placement");
        }
        this.checkLength(EdiConstants.DataType.REAL, length, minl, maxl);
        this.advance();
        if (exponent >= 0) {
            BigDecimal base = new BigDecimal(text.substring(0, exponent));
            int power = Integer.valueOf(text.substring(exponent + 1));
            return base.scaleByPowerOfTen(power);
        }
        return new BigDecimal(text);
    }

    public Number parseNumeric(int minl, int maxl) throws IOException {
        String text = this.token;
        int length = 0;
        boolean decimal = false;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') {
                ++length;
                continue;
            }
            if (!decimal && chr == '.') {
                decimal = true;
                continue;
            }
            if (i == 0 && (chr == '+' || chr == '-')) continue;
            this.handleError(EdiConstants.DataType.REAL, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed or wrong placement");
        }
        this.checkLength(EdiConstants.DataType.REAL, length, minl, maxl);
        this.advance();
        if (decimal) {
            return new BigDecimal(text);
        }
        return new BigInteger(text);
    }

    public Calendar parseDate(int minl, int maxl) throws IOException {
        int year;
        String text = this.token;
        int length = text.length();
        if (length != 6 && length != 8) {
            this.handleError(EdiConstants.DataType.DATE, ErrorHandler.ErrorCondition.INVALID_DATE, "date value must be either 6 or 8 characters");
        }
        this.checkLength(EdiConstants.DataType.DATE, minl, maxl);
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.handleError(EdiConstants.DataType.DATE, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        int day = text.charAt(length - 1) - 48 + (text.charAt(length - 2) - 48) * 10;
        int month = text.charAt(length - 3) - 48 + (text.charAt(length - 4) - 48) * 10;
        if (month == 0 || month > 12 || day == 0 || day > 31) {
            this.handleError(EdiConstants.DataType.DATE, ErrorHandler.ErrorCondition.INVALID_DATE, "month or day out of allowed range");
        }
        if (length == 8) {
            year = Integer.parseInt(text.substring(0, 4));
        } else {
            year = 2000 + (text.charAt(1) - 48) + (text.charAt(0) - 48) * 10;
            if (year > 2070) {
                year -= 100;
            }
        }
        this.advance();
        return new GregorianCalendar(year, month - 1, day);
    }

    public BigDecimal parseImpliedDecimalNumber(int scale, int minl, int maxl) throws IOException {
        return new BigDecimal(this.parseBigInteger(minl, maxl), scale);
    }

    public int parseTime(int minl, int maxl) throws IOException {
        int second;
        String text = this.token;
        int length = text.length();
        if (length != 4 && (length < 6 || length > 8)) {
            this.handleError(EdiConstants.DataType.TIME, ErrorHandler.ErrorCondition.INVALID_DATE, "time value must be either 4 or 6-8 characters");
        }
        this.checkLength(EdiConstants.DataType.TIME, minl, maxl);
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.handleError(EdiConstants.DataType.TIME, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        int hour = (text.charAt(0) - 48) * 10 + (text.charAt(1) - 48);
        int minute = (text.charAt(2) - 48) * 10 + (text.charAt(3) - 48);
        int n = second = text.length() < 6 ? 0 : (text.charAt(4) - 48) * 10 + (text.charAt(5) - 48);
        if (hour > 23 || minute > 59 || second > 59) {
            this.handleError(EdiConstants.DataType.TIME, ErrorHandler.ErrorCondition.INVALID_TIME, "time value out of allowed ranges");
        }
        int milli = 0;
        if (length > 6) {
            milli = (text.charAt(6) - 48) * 100;
            if (length > 7) {
                milli = (text.charAt(7) - 48) * 10;
            }
        }
        this.advance();
        return ((hour * 60 + minute) * 60 + second) * 1000 + milli;
    }
}

