/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DelimiterLexer
extends LexerBase {
    protected static final Logger logger = LogManager.getLogger(DelimiterLexer.class);
    protected boolean[] allowedChars;
    protected char dataSeparator;
    protected int repetitionSeparator = -1;
    protected char componentSeparator;
    protected int subCompSeparator = -1;
    protected int releaseIndicator = -1;
    protected char segmentTerminator;
    protected int tagDelimiter = -1;
    protected StringBuilder peekToken = new StringBuilder();
    protected String segmentTag;
    private int repetitionNumber;
    private int componentNumber;
    private int subCompNumber;
    private EdiConstants.ItemType nextType;
    private EdiConstants.ItemType peekType;

    public DelimiterLexer(InputStream is, int altmark) {
        super(is, altmark);
    }

    public char getDataSeparator() {
        return this.dataSeparator;
    }

    public int getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public char getComponentSeparator() {
        return this.componentSeparator;
    }

    public int getReleaseIndicator() {
        return this.releaseIndicator;
    }

    public char getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public int getRepetitionNumber() {
        return this.repetitionNumber;
    }

    public int getComponentNumber() {
        return this.componentNumber;
    }

    public int getSubComponentNumber() {
        return this.subCompNumber;
    }

    public boolean hasData() {
        return this.tokenBuilder.length() > 0;
    }

    public EdiConstants.ItemType nextType() {
        return this.nextType;
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber);
        if (this.repetitionNumber > 0) {
            position = "repetition " + Integer.toString(this.repetitionNumber + 1) + " of " + position;
        }
        switch (this.currentType) {
            case SUB_COMPONENT: 
            case COMPONENT: {
                position = "component " + Integer.toString(this.componentNumber + 1) + " of " + position;
                if (this.currentType != EdiConstants.ItemType.SUB_COMPONENT) break;
                position = "subcomponent " + Integer.toString(this.subCompNumber + 1) + " of " + position;
            }
        }
        String text = err.text() + " for data type " + typ.typeCode() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                logger.error("Unrecoverable lexer error " + text);
            } else {
                logger.info("Recoverable lexer error " + text);
            }
        }
    }

    protected abstract void handleEscape() throws IOException;

    public String segmentTag() {
        return this.segmentTag;
    }

    public void peek() throws IOException {
        if (this.peekType == null) {
            int value = this.reader.read();
            if (this.nextType == EdiConstants.ItemType.SEGMENT) {
                while (value == 10 || value == 13 || value == 32) {
                    value = this.reader.read();
                }
            }
            this.peekToken.setLength(0);
            if (value < 0) {
                this.peekType = EdiConstants.ItemType.END;
            } else {
                char chr = (char)value;
                while (true) {
                    if (chr == this.subCompSeparator) {
                        this.peekType = EdiConstants.ItemType.SUB_COMPONENT;
                        break;
                    }
                    if (chr == this.componentSeparator) {
                        this.peekType = EdiConstants.ItemType.COMPONENT;
                        break;
                    }
                    if (chr == this.dataSeparator) {
                        this.peekType = EdiConstants.ItemType.DATA_ELEMENT;
                        break;
                    }
                    if (chr == this.segmentTerminator) {
                        this.peekType = EdiConstants.ItemType.SEGMENT;
                        break;
                    }
                    if (chr == this.repetitionSeparator) {
                        this.peekType = EdiConstants.ItemType.REPETITION;
                        break;
                    }
                    if (chr == this.releaseIndicator) {
                        this.handleEscape();
                    } else {
                        if (this.nextType == EdiConstants.ItemType.SEGMENT && chr == this.tagDelimiter) {
                            this.peekType = EdiConstants.ItemType.DATA_ELEMENT;
                            break;
                        }
                        if (value == -1) {
                            this.peekType = EdiConstants.ItemType.END;
                            break;
                        }
                        this.peekToken.append(chr);
                    }
                    value = this.reader.read();
                    chr = (char)value;
                }
            }
        }
    }

    public void advance() throws IOException {
        this.peek();
        if (this.nextType == EdiConstants.ItemType.SEGMENT && this.peekType == EdiConstants.ItemType.END) {
            this.nextType = EdiConstants.ItemType.END;
        }
        this.currentType = this.nextType;
        switch (this.currentType) {
            case DATA_ELEMENT: {
                ++this.elementNumber;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SEGMENT: {
                ++this.segmentNumber;
                this.segmentTag = this.peekToken.toString();
            }
            case END: {
                this.elementNumber = 0;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SUB_COMPONENT: {
                ++this.subCompNumber;
                break;
            }
            case COMPONENT: {
                ++this.componentNumber;
                break;
            }
            case REPETITION: {
                ++this.repetitionNumber;
                this.componentNumber = 0;
            }
        }
        StringBuilder hold = this.tokenBuilder;
        this.tokenBuilder = this.peekToken;
        hold.setLength(0);
        this.peekToken = hold;
        this.nextType = this.peekType;
        this.peekType = null;
    }

    public String peekToken() throws IOException {
        this.peek();
        return this.peekType == EdiConstants.ItemType.END ? null : this.peekToken.toString();
    }

    protected void advance(EdiConstants.ItemType type) throws IOException {
        this.nextType = type;
        this.advance();
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        this.advance();
        while (this.currentType != typ && this.currentType != EdiConstants.ItemType.END) {
            this.advance();
        }
    }
}

