/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;
import java.math.BigDecimal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XmlDateFormat
extends TypeFormatBase {
    private final DatatypeFactory typeFactory;
    private final Variation formatVariation;

    public XmlDateFormat(String code, int min, int max, Variation var) {
        super(code, min, max);
        this.formatVariation = var;
        try {
            this.typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.DATETIME;
    }

    private int parseComponent(int start, int end, LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int value = 0;
        for (int i = start; i < end; ++i) {
            int chr = builder.charAt(i);
            if (chr < 48 || chr > 57) {
                lexer.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + (char)chr + "' not allowed");
                chr = 48;
            }
            value = value * 10 + chr - 48;
        }
        return value;
    }

    private XMLGregorianCalendar parseDateTime(LexerBase lexer) throws LexicalException {
        char sign;
        XMLGregorianCalendar dt = this.typeFactory.newXMLGregorianCalendar();
        StringBuilder builder = lexer.tokenBuilder();
        int length = builder.length();
        if (length > 5 && ((sign = builder.charAt(length - 5)) == '-' || sign == '+')) {
            int hours = this.parseComponent(length - 4, length - 2, lexer);
            int mins = this.parseComponent(length - 2, length, lexer);
            if (hours > 23) {
                lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "time zone offset hours value out of range: " + hours);
                hours = 23;
            }
            if (mins > 59) {
                lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "time zone offset minutes value out of range: " + mins);
                mins = 59;
            }
            int offset = hours * 60 + mins;
            dt.setTimezone(sign == '-' ? -offset : offset);
            length -= 5;
        }
        if (length < 4 || length < 14 && length % 2 == 1 || length > 19) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "length does not match a date/time format: " + builder.substring(0, length));
        }
        if (length >= 4) {
            dt.setYear(this.parseComponent(0, 4, lexer));
            if (length >= 6) {
                dt.setMonth(this.parseComponent(4, 6, lexer));
                if (length >= 8) {
                    dt.setDay(this.parseComponent(6, 8, lexer));
                    if (length >= 10) {
                        dt.setHour(this.parseComponent(8, 10, lexer));
                        if (length >= 12) {
                            dt.setMinute(this.parseComponent(10, 12, lexer));
                            if (length >= 14) {
                                dt.setSecond(this.parseComponent(12, 14, lexer));
                                if (length >= 16 && builder.charAt(14) == '.') {
                                    try {
                                        dt.setFractionalSecond(new BigDecimal(builder.substring(14, length)));
                                    }
                                    catch (NumberFormatException e) {
                                        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "invalid second fraction: " + builder.substring(0, length));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return dt;
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        this.checkInputLength(lexer);
        return this.parseDateTime(lexer);
    }

    private void writeDateTime(XMLGregorianCalendar dt, WriterBase writer) throws IOException {
        int offset;
        int value;
        StringBuilder builder = new StringBuilder();
        boolean fulldate = false;
        if (this.formatVariation == Variation.DATE || this.formatVariation == Variation.DATETIME) {
            value = dt.getYear();
            if (value == Integer.MIN_VALUE) {
                throw new WriteException("missing required year value for date/time");
            }
            XmlDateFormat.appendFourDigit(value, builder);
            value = dt.getMonth();
            if (value != Integer.MIN_VALUE) {
                XmlDateFormat.appendTwoDigit(value, builder);
                value = dt.getDay();
                if (value != Integer.MIN_VALUE) {
                    XmlDateFormat.appendTwoDigit(value, builder);
                    fulldate = true;
                }
            }
        }
        if ((this.formatVariation == Variation.TIME || fulldate && this.formatVariation == Variation.DATETIME) && (value = dt.getHour()) != Integer.MIN_VALUE) {
            XmlDateFormat.appendTwoDigit(value, builder);
            value = dt.getMinute();
            if (value != Integer.MIN_VALUE) {
                XmlDateFormat.appendTwoDigit(value, builder);
                value = dt.getSecond();
                if (value != Integer.MIN_VALUE) {
                    XmlDateFormat.appendTwoDigit(value, builder);
                    BigDecimal fract = dt.getFractionalSecond();
                    if (fract != null) {
                        builder.append(fract.toPlainString());
                    }
                }
            }
        }
        if ((offset = dt.getTimezone()) != Integer.MIN_VALUE) {
            builder.append(offset < 0 ? (char)'-' : '+');
            offset = Math.abs(offset);
            XmlDateFormat.appendTwoDigit(offset / 60, builder);
            XmlDateFormat.appendTwoDigit(offset % 60, builder);
        }
        if (builder.length() < this.minLength) {
            writer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "date/time value missing required components");
        }
        if (builder.length() > this.maxLength) {
            this.tooLong(builder.length(), writer);
            builder.setLength(this.maxLength);
        }
        writer.writeToken(builder.toString());
    }

    private static int skipDigits(int index, String time) {
        char chr;
        while (index < time.length() && (chr = time.charAt(index)) >= '0' && chr <= '9') {
            ++index;
        }
        return index;
    }

    @Override
    public void write(Object value, WriterBase writer) throws IOException {
        if (value instanceof XMLGregorianCalendar) {
            this.writeDateTime((XMLGregorianCalendar)value, writer);
        } else if (value instanceof String) {
            char chr;
            int index;
            String time = (String)value;
            if (time.length() < this.minLength) {
                writer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "date/time value too short");
            }
            if (time.length() > this.maxLength) {
                this.tooLong(time.length(), writer);
                time = time.substring(this.maxLength);
            }
            if ((index = XmlDateFormat.skipDigits(0, time)) < time.length()) {
                if (index < 6) {
                    writer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "invalid date/time string");
                    index = time.length();
                }
                if (index < time.length() && time.charAt(index) == '.') {
                    index = XmlDateFormat.skipDigits(index + 1, time);
                }
            }
            if (index < time.length() && ((chr = time.charAt(index)) != '+' && chr != '-' || time.length() - index != 5)) {
                writer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "invalid date/time string");
            }
            writer.writeToken(time);
        } else {
            this.wrongType(value, writer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof XmlDateFormat && this.formatVariation == ((XmlDateFormat)obj).formatVariation && super.equals(obj);
    }

    public static enum Variation {
        DATE,
        TIME,
        DATETIME;

    }
}

