/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DelimiterWriter
extends WriterBase {
    protected static final Logger logger = LogManager.getLogger(DelimiterWriter.class);
    private final boolean[] allowedChars;
    protected final int subCompSeparator;
    protected final char componentSeparator;
    protected final char dataSeparator;
    protected final int repetitionSeparator;
    protected final int releaseIndicator;
    protected final int tagDelimiter;
    protected final String segmentSeparator;
    private final char segmentTerminator;
    private boolean segmentStart;
    protected int groupCount;
    private int skippedElementCount;
    private int skippedCompCount;
    private int skippedSubCompCount;
    private boolean atTag;

    protected DelimiterWriter(OutputStream os, Charset encoding, char datasep, char compsep, int subsep, int repsep, char segterm, String segsep, int tagsep, int release, int subst, char mark, boolean[] chars) {
        super(new BufferedWriter(new OutputStreamWriter(os, encoding)), mark);
        this.dataSeparator = datasep;
        this.componentSeparator = compsep;
        this.subCompSeparator = subsep;
        this.repetitionSeparator = repsep;
        this.segmentTerminator = segterm;
        this.segmentSeparator = segsep;
        this.releaseIndicator = release;
        this.tagDelimiter = tagsep;
        this.substitutionChar = subst;
        int limit = Math.max(datasep, Math.max(compsep, Math.max(subsep, Math.max(repsep, Math.max(segterm, release)))));
        boolean[] allowed = null;
        if (chars == null) {
            int size = Math.max(limit, 128);
            allowed = DelimiterWriter.initFlags(size);
        } else if (limit > chars.length) {
            allowed = DelimiterWriter.initFlags(limit);
            System.arraycopy(chars, 0, allowed, 0, chars.length);
        } else {
            allowed = new boolean[chars.length];
            System.arraycopy(chars, 0, allowed, 0, chars.length);
        }
        DelimiterWriter.clearFlag(datasep, allowed);
        DelimiterWriter.clearFlag(compsep, allowed);
        DelimiterWriter.clearFlag(subsep, allowed);
        DelimiterWriter.clearFlag(repsep, allowed);
        DelimiterWriter.clearFlag(segterm, allowed);
        if (release > 0) {
            DelimiterWriter.clearFlag(release, allowed);
        }
        this.allowedChars = allowed;
    }

    private static boolean[] initFlags(int length) {
        boolean[] flags = new boolean[length];
        for (int i = 0; i < length; ++i) {
            flags[i] = true;
        }
        return flags;
    }

    private static void clearFlag(int chr, boolean[] flags) {
        if (chr >= 0 && chr < flags.length) {
            flags[chr] = false;
        }
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public void skipElement() {
        ++this.skippedElementCount;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void skipComponent() {
        ++this.skippedCompCount;
        this.skippedSubCompCount = 0;
    }

    public void skipSubcomponent() {
        ++this.skippedSubCompCount;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public abstract String convertEscape(char var1) throws WriteException;

    private void checkSegmentStart() throws IOException {
        if (this.segmentStart && this.segmentSeparator != null) {
            this.writer.write(this.segmentSeparator);
        }
        this.segmentStart = false;
    }

    public void writeDataSeparator() throws IOException {
        char delim = this.dataSeparator;
        if (this.atTag) {
            if (this.tagDelimiter >= 0) {
                delim = (char)this.tagDelimiter;
            }
            this.atTag = false;
        }
        this.writer.write(delim);
        for (int i = 0; i < this.skippedElementCount; ++i) {
            this.writer.write(this.dataSeparator);
        }
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeComponentSeparator() throws IOException {
        this.writer.write(this.componentSeparator);
        for (int i = 0; i < this.skippedCompCount; ++i) {
            this.writer.write(this.componentSeparator);
        }
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeSubcomponentSeparator() throws IOException {
        this.writer.write((char)this.subCompSeparator);
        for (int i = 0; i < this.skippedSubCompCount; ++i) {
            this.writer.write(this.subCompSeparator);
        }
        this.skippedSubCompCount = 0;
    }

    public void writeSegmentTag(String tag) throws IOException {
        this.writeToken(tag);
        this.atTag = true;
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        this.writer.write(this.segmentTerminator);
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
        ++this.segmentCount;
        this.segmentStart = true;
    }

    public void writeRepetitionSeparator() throws IOException {
        this.writer.write(this.repetitionSeparator);
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    @Override
    public void writeUnchecked(char[] chars, int offset, int length) throws IOException {
        this.writer.write(chars, offset, length);
    }

    @Override
    public void writeUnchecked(String text) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void writeEscaped(String text) throws IOException {
        StringBuilder builder = new StringBuilder(text);
        for (int i = 0; i < builder.length(); ++i) {
            char chr = builder.charAt(i);
            if (chr >= this.allowedChars.length || this.allowedChars[chr]) continue;
            if (this.releaseIndicator >= 0 && (chr == this.segmentTerminator || chr == this.dataSeparator || chr == this.componentSeparator || chr == this.subCompSeparator || chr == this.repetitionSeparator || chr == this.releaseIndicator)) {
                String escape = this.convertEscape(chr);
                builder.replace(i, i + 1, escape);
                i += escape.length() - 1;
                continue;
            }
            if (this.substitutionChar >= 0) {
                builder.setCharAt(i, (char)this.substitutionChar);
                continue;
            }
            throw new WriteException("invalid character " + chr + " in data with no release character and/or substitution character defined");
        }
        this.writer.write(builder.toString());
    }

    @Override
    public void startToken() throws IOException {
        this.checkSegmentStart();
    }

    @Override
    public void writeToken(String text) throws IOException {
        this.startToken();
        this.writeEscaped(text);
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err, String text) throws LexicalException {
        boolean abort = false;
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(typ, err, text);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                logger.error("Unrecoverable writer error " + text);
            } else {
                logger.info("Recoverable writer error " + text);
            }
        }
    }

    public static Object getRequired(String key, Map<String, Object> props) throws WriteException {
        Object value = props.get(key);
        if (value == null) {
            throw new WriteException("missing required property value '" + key + "'");
        }
        return value;
    }

    public void writeProperty(String key, Map<String, Object> props, Object dflt, TypeFormat vtype) throws IOException {
        try {
            if (dflt == null) {
                vtype.write(DelimiterWriter.getRequired(key, props), this);
            } else {
                Object value = props.get(key);
                if (value == null) {
                    value = dflt;
                }
                vtype.write(value, this);
            }
        }
        catch (LexicalDataException lde) {
            throw new LexicalDataException(lde, key);
        }
        this.writeDataSeparator();
    }
}

