/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.control;

import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.control.StructureController;
import com.mulesoft.flatfile.lexical.control.WithGroupsStructureController;
import com.mulesoft.flatfile.lexical.control.WithoutGroupsStructureController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureControlManager {
    private StructureController controller;
    private static final Map<String, List<String>> envelopeSegmentsMap = new HashMap<String, List<String>>();
    private List<String> envelopeSegmentList;

    public synchronized void initStructureControl(boolean containsGroups, String ediFormIdent) {
        this.envelopeSegmentList = envelopeSegmentsMap.get(ediFormIdent);
        this.controller = containsGroups ? new WithGroupsStructureController(this.envelopeSegmentList) : new WithoutGroupsStructureController(this.envelopeSegmentList);
        this.controller.startControl();
    }

    public void verifyEnvelopeSegmentHierarchy(boolean isReject, String currentTag) throws LexicalException {
        if (isReject && this.controller.isEnvelopeClosingSegment(currentTag)) {
            this.controller.pop();
        } else if (!this.controller.isValidEnvelopeSequence(currentTag)) {
            throw new LexicalException(String.format("Invalid envelope segment '%s', last envelope segment is '%s'.", currentTag, this.controller.getAtTopEnvelopeIdent()));
        }
    }

    public boolean isEnvelopeSegment(String currentSegmentIdent) {
        return this.envelopeSegmentList.contains(currentSegmentIdent);
    }

    public void addStructure(String envelopeSegmentIdent) {
        this.controller.push(envelopeSegmentIdent);
    }

    public void removeStructure() {
        this.controller.pop();
    }

    public synchronized void stopStructureControl() {
        this.controller = null;
    }

    static {
        envelopeSegmentsMap.put("X12", Arrays.asList("ISA", "GS", "ST", "SE", "GE", "IEA"));
        envelopeSegmentsMap.put("HIPAA", Arrays.asList("ISA", "GS", "ST", "SE", "GE", "IEA"));
        envelopeSegmentsMap.put("EDIFACT", Arrays.asList("UNB", "UNG", "UNH", "UNT", "UNE", "UNZ"));
        envelopeSegmentsMap.put("TRADACOMS", Arrays.asList("STX", "MHD", "MTR", "END"));
    }
}

