/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;

public class MillisecondTimeFormat
extends TypeFormatBase {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;

    public MillisecondTimeFormat(String code, int min2, int max2) {
        super(code, min2, max2);
        if (min2 < 4) {
            throw new IllegalArgumentException("Time value representation requires at least 4 characters");
        }
        if (max2 > 9) {
            throw new IllegalArgumentException("Time value representation is a maximum of 9 characters");
        }
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.INTEGER;
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        int second;
        this.verifyDigits(lexer);
        this.checkInputLength(lexer);
        StringBuilder builder = lexer.tokenBuilder();
        int length = builder.length();
        if (length != 4 && length < 6) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, "time value must be either exactly 4 or 6-9 characters");
        }
        int hour = (builder.charAt(0) - 48) * 10 + (builder.charAt(1) - 48);
        int minute = (builder.charAt(2) - 48) * 10 + (builder.charAt(3) - 48);
        int n = second = builder.length() < 6 ? 0 : (builder.charAt(4) - 48) * 10 + (builder.charAt(5) - 48);
        if (hour > 23 || minute > 59 || second > 59) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_TIME, "time value out of allowed ranges");
        }
        int milli = 0;
        if (length > 6) {
            milli += (builder.charAt(6) - 48) * 100;
            if (length > 7) {
                milli += (builder.charAt(7) - 48) * 10;
                if (length > 8) {
                    milli += builder.charAt(8) - 48;
                }
            }
        }
        return ((hour * 60 + minute) * 60 + second) * 1000 + milli;
    }

    private void writeMilliseconds(int millis, WriterBase writer) throws IOException {
        int remain = millis;
        StringBuilder builder = new StringBuilder();
        int hour = remain / 3600000;
        MillisecondTimeFormat.appendTwoDigit(hour, builder);
        int minute = (remain %= 3600000) / 60000;
        MillisecondTimeFormat.appendTwoDigit(minute, builder);
        if (this.maxLength > 4 && (remain %= 60000) > 0) {
            int second = remain / 1000;
            MillisecondTimeFormat.appendTwoDigit(second, builder);
            if (this.maxLength > 7 && (remain %= 1000) > 10) {
                MillisecondTimeFormat.appendTwoDigit(remain / 10, builder);
            } else if (this.maxLength == 7 && remain > 100) {
                builder.append(remain / 100);
            } else if (this.minLength > 7) {
                builder.append("00");
            } else if (this.minLength > 6) {
                builder.append('0');
            }
        }
        writer.startToken();
        while (builder.length() < this.minLength) {
            builder.append('0');
        }
        writer.writeUnchecked(builder.toString());
    }

    @Override
    public void write(Object value2, WriterBase writer) throws IOException {
        if (value2 instanceof Integer) {
            this.writeMilliseconds((Integer)value2, writer);
        } else if (value2 instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value2;
            this.writeMilliseconds((int)(localTime.toNanoOfDay() / 1000000L), writer);
        } else if (value2 instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)value2;
            this.writeMilliseconds((int)(offsetTime.toLocalTime().toNanoOfDay() / 1000000L), writer);
        } else if (value2 instanceof OffsetDateTime) {
            OffsetDateTime dateTime = (OffsetDateTime)value2;
            this.writeMilliseconds((int)(dateTime.toLocalTime().toNanoOfDay() / 1000000L), writer);
        } else {
            this.wrongType(value2, writer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MillisecondTimeFormat && super.equals(obj);
    }
}

