/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber;
import spire.math.Number;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.RationalAlgebra;
import spire.math.RationalInstances;
import spire.math.RationalInstances$class;
import spire.math.RationalNumber;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;

public final class Rational$
implements RationalInstances,
Serializable {
    public static final Rational$ MODULE$;
    private final Regex RationalString;
    private final Regex IntegerString;
    private final Rational zero;
    private final Rational one;
    private final RationalAlgebra RationalAlgebra;
    private final NumberTag.LargeTag<Rational> RationalTag;

    static {
        new Rational$();
    }

    @Override
    public final RationalAlgebra RationalAlgebra() {
        return this.RationalAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Rational> RationalTag() {
        return this.RationalTag;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalAlgebra_$eq(RationalAlgebra x$1) {
        this.RationalAlgebra = x$1;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalTag_$eq(NumberTag.LargeTag x$1) {
        this.RationalTag = x$1;
    }

    private Regex RationalString() {
        return this.RationalString;
    }

    private Regex IntegerString() {
        return this.IntegerString;
    }

    public Rational zero() {
        return this.zero;
    }

    public Rational one() {
        return this.one;
    }

    /*
     * Unable to fully structure code
     */
    public double toDouble(SafeLong n, SafeLong d) {
        var3_3 = n.signum();
        switch (var3_3) {
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(var3_3));
            }
            case 1: {
                sharedLength = Math.min(n.bitLength(), d.bitLength());
                dLowerLength = d.bitLength() - sharedLength;
                nShared = n.$greater$greater(n.bitLength() - sharedLength);
                dShared = d.$greater$greater(dLowerLength);
                if (nShared.$less(dShared)) ** GOTO lbl-1000
                v0 = nShared != dShared ? (nShared != null ? (!(nShared instanceof java.lang.Number) ? (!(nShared instanceof Character) ? nShared.equals(dShared) : BoxesRunTime.equalsCharObject((Character)nShared, dShared)) : BoxesRunTime.equalsNumObject(nShared, dShared)) : false) : true;
                if (v0 && d.toBigInteger().getLowestSetBit() < dLowerLength) lbl-1000:
                // 2 sources

                {
                    v1 = 1;
                } else {
                    v1 = 0;
                }
                addBit = v1;
                e = d.bitLength() - n.bitLength() + addBit;
                ln = n.$less$less(53 + e);
                lm = ln.$div(d).toLong();
                m = (lm >> 1) + (lm & 1L) & 0xFFFFFFFFFFFFFL;
                bits = m | 1023L - (long)e << 52;
                v2 = Double.longBitsToDouble(bits);
                break;
            }
            case -1: {
                v2 = -this.toDouble(n.unary_$minus(), d);
                break;
            }
            case 0: {
                v2 = 0.0;
            }
        }
        return v2;
    }

    public Rational apply(BigInt n, BigInt d) {
        return this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(d));
    }

    public Rational apply(long n, long d) {
        if (d == 0L) {
            throw new IllegalArgumentException("0 denominator");
        }
        return d > 0L ? this.build0$1(n, d) : (n == Long.MIN_VALUE || d == Long.MIN_VALUE ? this.apply(scala.package$.MODULE$.BigInt().apply(n).unary_$minus(), scala.package$.MODULE$.BigInt().apply(d).unary_$minus()) : this.build0$1(-n, -d));
    }

    /*
     * WARNING - void declaration
     */
    public Rational buildWithDiv(long num, long ngcd, long rd, long lden) {
        void var11_6;
        void var9_5;
        long n = num / ngcd;
        long d = rd / ngcd;
        long z$macro$432 = lden * d;
        if (lden == 0L || d == z$macro$432 / lden && (lden != -1L || d != Long.MIN_VALUE)) {
            return this.apply(n, z$macro$432);
        }
        return this.checked$fallback$macro$431$1(lden, (long)var9_5, (long)var11_6);
    }

    public Rational apply(SafeLong n, SafeLong d) {
        SafeLong safeLong;
        block13: {
            Rational rational2;
            block7: {
                Rational rational3;
                block12: {
                    SafeLong g;
                    block8: {
                        SafeLong safeLong2;
                        block11: {
                            Rational rational4;
                            block10: {
                                SafeLongLong safeLongLong;
                                block9: {
                                    while (true) {
                                        if (d.isZero()) {
                                            throw new IllegalArgumentException("0 denominator");
                                        }
                                        if (n.isValidLong() && d.isValidLong()) {
                                            rational2 = this.apply(n.toLong(), d.toLong());
                                            break block7;
                                        }
                                        if (d.signum() >= 0) break;
                                        d = d.unary_$minus();
                                        n = n.unary_$minus();
                                    }
                                    g = n.gcd(d);
                                    safeLong = n.$div(g);
                                    if (!(safeLong instanceof SafeLongLong)) break block8;
                                    safeLongLong = (SafeLongLong)safeLong;
                                    safeLong2 = d.$div(g);
                                    if (!(safeLong2 instanceof SafeLongLong)) break block9;
                                    SafeLongLong safeLongLong2 = (SafeLongLong)safeLong2;
                                    rational4 = this.spire$math$Rational$$longRational(safeLongLong.x(), safeLongLong2.x());
                                    break block10;
                                }
                                if (!(safeLong2 instanceof SafeLongBigInteger)) break block11;
                                SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong2;
                                rational4 = this.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(safeLongLong.x()), safeLongBigInteger);
                            }
                            rational3 = rational4;
                            break block12;
                        }
                        throw new MatchError(safeLong2);
                    }
                    if (!(safeLong instanceof SafeLongBigInteger)) break block13;
                    SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                    rational3 = this.spire$math$Rational$$bigRational(safeLongBigInteger, d.$div(g));
                }
                rational2 = rational3;
            }
            return rational2;
        }
        throw new MatchError(safeLong);
    }

    public Rational apply(int x) {
        return x == 0 ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
    }

    public Rational apply(long x) {
        return x == 0L ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
    }

    public Rational apply(BigInt x) {
        return this.apply(SafeLong$.MODULE$.apply(x), SafeLong$.MODULE$.one());
    }

    public Rational apply(float x) {
        return this.apply((double)x);
    }

    public Rational apply(double x) {
        Rational rational2;
        if (x == 0.0) {
            rational2 = this.zero();
        } else {
            long bits2 = Double.doubleToLongBits(x);
            long value2 = bits2 >> 63 < 0L ? -(bits2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L) : bits2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int exp = (int)(bits2 >> 52 & 0x7FFL) - 1075;
            rational2 = exp > 10 ? this.apply(SafeLong$.MODULE$.apply(value2).$less$less(exp), SafeLong$.MODULE$.one()) : (exp >= 0 ? this.apply(value2 << exp, 1L) : (exp >= -52 && ((-1L << -exp ^ 0xFFFFFFFFFFFFFFFFL) & value2) == 0L ? this.apply(value2 >> -exp, 1L) : this.apply(SafeLong$.MODULE$.apply(value2), SafeLong$.MODULE$.one().$less$less(-exp))));
        }
        return rational2;
    }

    public Rational apply(BigDecimal x) {
        Rational rational2;
        if (x.ulp().$greater$eq(BigDecimal$.MODULE$.int2bigDecimal(1))) {
            rational2 = this.apply(x.toBigInt(), BigInt$.MODULE$.int2bigInt(1));
        } else {
            BigInt n = x.$div(x.ulp()).toBigInt();
            BigInt d = scala.package$.MODULE$.BigDecimal().apply(1.0).$div(x.ulp()).toBigInt();
            rational2 = this.apply(n, d);
        }
        return rational2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rational apply(String r) {
        String string2 = r;
        Option<List<String>> option2 = this.RationalString().unapplySeq(r);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            String n = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String d = (String)((LinearSeqOptimized)option2.get()).apply(1);
            return this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(d));
        }
        Option<List<String>> option3 = this.IntegerString().unapplySeq(r);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
            String n = (String)((LinearSeqOptimized)option3.get()).apply(0);
            return this.apply(SafeLong$.MODULE$.apply(n));
        }
        try {
            return this.apply(scala.package$.MODULE$.BigDecimal().apply(r));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(new StringBuilder().append((Object)"For input string: ").append((Object)string2).toString());
        }
    }

    public Rational apply(SafeLong n) {
        block4: {
            Rational rational2;
            block3: {
                block2: {
                    if (!(n instanceof SafeLongLong)) break block2;
                    SafeLongLong safeLongLong = (SafeLongLong)n;
                    rational2 = safeLongLong.x() == 0L ? this.zero() : this.spire$math$Rational$$longRational(safeLongLong.x(), 1L);
                    break block3;
                }
                if (!(n instanceof SafeLongBigInteger)) break block4;
                SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)n;
                rational2 = this.spire$math$Rational$$bigRational(safeLongBigInteger, SafeLong$.MODULE$.one());
            }
            return rational2;
        }
        throw new MatchError(n);
    }

    public Rational apply(Number x) {
        block6: {
            Rational rational2;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!(x instanceof RationalNumber)) break block2;
                            RationalNumber rationalNumber = (RationalNumber)x;
                            rational2 = rationalNumber.n();
                            break block3;
                        }
                        if (!(x instanceof IntNumber)) break block4;
                        IntNumber intNumber = (IntNumber)x;
                        rational2 = this.apply(intNumber.n());
                        break block3;
                    }
                    if (!(x instanceof FloatNumber)) break block5;
                    FloatNumber floatNumber = (FloatNumber)x;
                    rational2 = this.apply(floatNumber.n());
                    break block3;
                }
                if (!(x instanceof DecimalNumber)) break block6;
                DecimalNumber decimalNumber = (DecimalNumber)x;
                rational2 = this.apply(decimalNumber.n());
            }
            return rational2;
        }
        throw new MatchError(x);
    }

    public Rational.LongRational spire$math$Rational$$longRational(long n, long d) {
        return new Rational.LongRational(n, d);
    }

    public Rational.BigRational spire$math$Rational$$bigRational(SafeLong n, SafeLong d) {
        return new Rational.BigRational(n, d.isOne() ? SafeLong$.MODULE$.one() : d);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Rational build0$1(long n, long d) {
        long divisor;
        return n == 0L ? this.zero() : ((divisor = package$.MODULE$.gcd(n, d)) == 1L ? this.spire$math$Rational$$longRational(n, d) : this.spire$math$Rational$$longRational(n / divisor, d / divisor));
    }

    private final Rational checked$fallback$macro$431$1(long lden$1, long n$1, long d$1) {
        return this.apply(SafeLong$.MODULE$.apply(n$1), SafeLong$.MODULE$.apply(lden$1).$times(d$1));
    }

    private Rational$() {
        MODULE$ = this;
        RationalInstances$class.$init$(this);
        Predef$ predef$ = Predef$.MODULE$;
        this.RationalString = new StringOps("^(-?\\d+)/(-?\\d+)$").r();
        Predef$ predef$2 = Predef$.MODULE$;
        this.IntegerString = new StringOps("^(-?\\d+)$").r();
        this.zero = this.spire$math$Rational$$longRational(0L, 1L);
        this.one = this.spire$math$Rational$$longRational(1L, 1L);
    }
}

