/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.2.12.3.LogManager;
import org.apache.logging.log4j.2.12.3.Logger;

public abstract class DelimiterLexer
extends LexerBase {
    protected static final Logger logger = LogManager.getLogger(DelimiterLexer.class);
    protected boolean[] allowedChars;
    protected char dataSeparator;
    protected int repetitionSeparator = -1;
    protected char componentSeparator;
    protected int subCompSeparator = -1;
    protected int releaseIndicator = -1;
    protected char segmentTerminator;
    protected int tagDelimiter = -1;
    protected String segmentTag;
    private int repetitionNumber;
    private int componentNumber;
    private int subCompNumber;
    private EdiConstants.ItemType nextType;
    private final ArrayList<ParseItem> readAheads = new ArrayList();

    public DelimiterLexer(InputStream is, int altmark) {
        super(is, altmark);
    }

    public char getDataSeparator() {
        return this.dataSeparator;
    }

    public int getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public char getComponentSeparator() {
        return this.componentSeparator;
    }

    public int getReleaseIndicator() {
        return this.releaseIndicator;
    }

    public char getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public int getRepetitionNumber() {
        return this.repetitionNumber;
    }

    public int getComponentNumber() {
        return this.componentNumber;
    }

    public int getSubComponentNumber() {
        return this.subCompNumber;
    }

    public boolean hasData() {
        return this.tokenBuilder.length() > 0;
    }

    public EdiConstants.ItemType nextType() {
        return this.nextType;
    }

    @Override
    public void error(TypeFormat typ, ErrorHandler.ErrorCondition err2, String explain2) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber);
        if (this.repetitionNumber > 0) {
            position = "repetition " + Integer.toString(this.repetitionNumber + 1) + " of " + position;
        }
        switch (this.currentType) {
            case SUB_COMPONENT: 
            case COMPONENT: {
                position = "component " + Integer.toString(this.componentNumber + 1) + " of " + position;
                if (this.currentType != EdiConstants.ItemType.SUB_COMPONENT) break;
                position = "subcomponent " + Integer.toString(this.subCompNumber + 1) + " of " + position;
            }
        }
        String text = err2.text() + " for data type " + typ.typeCode() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain2 != null) {
            text = text + " (" + explain2 + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err2, text);
            }
            this.errorHandler.error(typ, err2, explain2);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                logger.error("Unrecoverable lexer error " + text);
            } else {
                logger.info("Recoverable lexer error " + text);
            }
        }
    }

    protected abstract void handleEscape(StringBuilder var1) throws IOException;

    public String segmentTag() {
        return this.segmentTag;
    }

    public ParseItem parseItem(EdiConstants.ItemType type) throws IOException {
        int value2 = this.reader.read();
        if (EdiConstants.ItemType.SEGMENT == type) {
            while (value2 == 10 || value2 == 13 || value2 == 32) {
                value2 = this.reader.read();
            }
        }
        StringBuilder builder = new StringBuilder();
        EdiConstants.ItemType next2 = null;
        if (value2 < 0) {
            next2 = EdiConstants.ItemType.END;
        } else {
            char chr = (char)value2;
            while (true) {
                if (chr == this.subCompSeparator) {
                    next2 = EdiConstants.ItemType.SUB_COMPONENT;
                    break;
                }
                if (chr == this.componentSeparator) {
                    next2 = EdiConstants.ItemType.COMPONENT;
                    break;
                }
                if (chr == this.dataSeparator) {
                    next2 = EdiConstants.ItemType.DATA_ELEMENT;
                    break;
                }
                if (chr == this.segmentTerminator) {
                    next2 = EdiConstants.ItemType.SEGMENT;
                    break;
                }
                if (chr == this.repetitionSeparator) {
                    next2 = EdiConstants.ItemType.REPETITION;
                    break;
                }
                if (chr == this.releaseIndicator) {
                    this.handleEscape(builder);
                } else {
                    if (type == EdiConstants.ItemType.SEGMENT && chr == this.tagDelimiter) {
                        next2 = EdiConstants.ItemType.DATA_ELEMENT;
                        break;
                    }
                    if (value2 == -1) {
                        next2 = EdiConstants.ItemType.END;
                        break;
                    }
                    builder.append(chr);
                }
                value2 = this.reader.read();
                chr = (char)value2;
            }
        }
        return new ParseItem(builder, type, next2);
    }

    private ParseItem nextItem(EdiConstants.ItemType last2) throws IOException {
        if (this.readAheads.size() > 0) {
            return this.readAheads.remove(0);
        }
        return this.parseItem(last2);
    }

    public void advance() throws IOException {
        ParseItem item = this.nextItem(this.nextType);
        this.currentType = item.itemType;
        this.nextType = item.nextType;
        if (item.itemType == EdiConstants.ItemType.SEGMENT && item.nextType == EdiConstants.ItemType.END) {
            this.currentType = EdiConstants.ItemType.END;
        }
        switch (this.currentType) {
            case DATA_ELEMENT: {
                ++this.elementNumber;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SEGMENT: {
                ++this.segmentNumber;
                this.segmentTag = item.token.toString();
            }
            case END: {
                this.elementNumber = 0;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SUB_COMPONENT: {
                ++this.subCompNumber;
                break;
            }
            case COMPONENT: {
                ++this.componentNumber;
                break;
            }
            case REPETITION: {
                ++this.repetitionNumber;
                this.componentNumber = 0;
            }
        }
        this.tokenBuilder = item.token;
    }

    public String peekToken() throws IOException {
        ParseItem item;
        if (this.readAheads.isEmpty()) {
            item = this.parseItem(this.nextType);
            this.readAheads.add(item);
        } else {
            item = this.readAheads.get(0);
        }
        return item.nextType == EdiConstants.ItemType.END ? null : item.token.toString();
    }

    protected void advance(EdiConstants.ItemType type) throws IOException {
        this.nextType = type;
        this.advance();
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        this.advance();
        while (this.currentType != typ && this.currentType != EdiConstants.ItemType.END) {
            this.advance();
        }
    }

    public Iterator<ParseItem> readAheadIterator() {
        return new ReadAheadIterator(this.nextType);
    }

    public static class ParseItem {
        public final StringBuilder token;
        public final EdiConstants.ItemType itemType;
        private final EdiConstants.ItemType nextType;

        private ParseItem(StringBuilder text, EdiConstants.ItemType type, EdiConstants.ItemType next2) {
            this.token = text;
            this.itemType = type;
            this.nextType = next2;
        }
    }

    private class ReadAheadIterator
    implements Iterator<ParseItem> {
        private int index;
        private EdiConstants.ItemType nextType;
        private boolean atEnd;

        private ReadAheadIterator(EdiConstants.ItemType next2) {
            this.nextType = next2;
        }

        @Override
        public boolean hasNext() {
            return !this.atEnd;
        }

        @Override
        public ParseItem next() {
            ParseItem item;
            if (this.index < DelimiterLexer.this.readAheads.size()) {
                item = (ParseItem)DelimiterLexer.this.readAheads.get(this.index);
            } else {
                try {
                    item = DelimiterLexer.this.parseItem(this.nextType);
                    DelimiterLexer.this.readAheads.add(item);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error in parser read-ahead processing", e);
                }
            }
            ++this.index;
            this.nextType = item.nextType;
            if (EdiConstants.ItemType.SEGMENT == this.nextType || EdiConstants.ItemType.END == this.nextType) {
                this.atEnd = true;
            }
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

