/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Double$;
import scala.Serializable;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber;
import spire.math.Natural;
import spire.math.Number;
import spire.math.NumberAlgebra;
import spire.math.NumberInstances;
import spire.math.NumberInstances$class;
import spire.math.Rational;
import spire.math.RationalNumber;
import spire.math.SafeLong;
import spire.math.SafeLong$;

public final class Number$
implements NumberInstances,
Serializable {
    public static final Number$ MODULE$;
    private final Number zero;
    private final Number one;
    private final SafeLong minInt;
    private final SafeLong maxInt;
    private final SafeLong minLong;
    private final SafeLong maxLong;
    private final BigDecimal minDouble;
    private final BigDecimal maxDouble;
    private final NumberAlgebra NumberAlgebra;

    static {
        new Number$();
    }

    @Override
    public final NumberAlgebra NumberAlgebra() {
        return this.NumberAlgebra;
    }

    @Override
    public final void spire$math$NumberInstances$_setter_$NumberAlgebra_$eq(NumberAlgebra x$1) {
        this.NumberAlgebra = x$1;
    }

    public final Number zero() {
        return this.zero;
    }

    public final Number one() {
        return this.one;
    }

    public Number apply(int n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n));
    }

    public Number apply(long n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n));
    }

    public Number apply(BigInt n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n));
    }

    public Number apply(SafeLong n) {
        return new IntNumber(n);
    }

    public Number apply(BigDecimal n) {
        return new DecimalNumber(n);
    }

    public Number apply(Rational n) {
        return new RationalNumber(n);
    }

    public Number apply(Natural n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n.toBigInt()));
    }

    public Number apply(float n) {
        if (Float.isNaN(n) || Float.isInfinite(n)) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToFloat(n)).toString());
        }
        return new FloatNumber(n);
    }

    public Number apply(double n) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToDouble(n)).toString());
        }
        return new FloatNumber(n);
    }

    public Number apply(String s2) {
        Number number2;
        try {
            number2 = this.apply(SafeLong$.MODULE$.apply(s2));
        }
        catch (Exception exception) {
            number2 = this.apply(package$.MODULE$.BigDecimal().apply(s2));
        }
        return number2;
    }

    public SafeLong minInt() {
        return this.minInt;
    }

    public SafeLong maxInt() {
        return this.maxInt;
    }

    public SafeLong minLong() {
        return this.minLong;
    }

    public SafeLong maxLong() {
        return this.maxLong;
    }

    public BigDecimal minDouble() {
        return this.minDouble;
    }

    public BigDecimal maxDouble() {
        return this.maxDouble;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Number$() {
        MODULE$ = this;
        NumberInstances$class.$init$(this);
        this.zero = this.apply(0);
        this.one = this.apply(1);
        this.minInt = SafeLong$.MODULE$.apply(Integer.MIN_VALUE);
        this.maxInt = SafeLong$.MODULE$.apply(Integer.MAX_VALUE);
        this.minLong = SafeLong$.MODULE$.apply(Long.MIN_VALUE);
        this.maxLong = SafeLong$.MODULE$.apply(Long.MAX_VALUE);
        this.minDouble = package$.MODULE$.BigDecimal().apply(Double$.MODULE$.MinValue());
        this.maxDouble = package$.MODULE$.BigDecimal().apply((double)Double.MAX_VALUE);
    }
}

