/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.tools;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.schema.model.EdiFact$;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.X12$;
import com.mulesoft.flatfile.schema.tools.DocumentTest;
import com.mulesoft.flatfile.schema.tools.DocumentTestEdifact;
import com.mulesoft.flatfile.schema.tools.DocumentTestX12;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DocumentTest$ {
    public static DocumentTest$ MODULE$;

    static {
        new DocumentTest$();
    }

    public EdiSchema loadSchema(String path, boolean identKeys, boolean codeSets, String csPath) {
        EdiSchema ediSchema;
        try {
            YamlReader yamlrdr = new YamlReader();
            YamlReader.InputSource source = YamlReader$.MODULE$.findSchema(path, (List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})));
            InputStreamReader reader = new InputStreamReader(source.input(), EdiConstants.ISO88591_CHARSET);
            EdiSchema schema = yamlrdr.loadYaml(reader, source.prefixPaths(), identKeys);
            if (codeSets) {
                String usePath = csPath != null ? csPath : source.directoryPath();
                ediSchema = yamlrdr.addCodeSets(schema, usePath, source.prefixPaths());
            } else {
                ediSchema = schema;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load schema file ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{path})), e);
        }
        return ediSchema;
    }

    public EdiSchema loadSchema(String path) {
        return this.loadSchema(path, false, false, null);
    }

    public String readAsString(String path) {
        String string;
        BufferedSource bufferedSource;
        File file = new File(path);
        if (file.exists()) {
            bufferedSource = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        } else {
            InputStream is = this.getClass().getResourceAsStream(path);
            if (is == null) {
                String relpath = path.startsWith(File.separator) ? path.substring(File.separator.length()) : path;
                InputStream is1 = this.getClass().getClassLoader().getResourceAsStream(relpath);
                if (is1 == null) {
                    throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path ", " not found"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{path})));
                }
                bufferedSource = Source$.MODULE$.fromInputStream(is1, Codec$.MODULE$.fallbackSystemCodec());
            } else {
                bufferedSource = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec());
            }
        }
        try (BufferedSource source = bufferedSource;){
            string = source.getLines().mkString("\n");
        }
        return string;
    }

    public String stripLineBreaks(String text) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(text)).filter((Function1<Object, Object> & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean(DocumentTest$.$anonfun$stripLineBreaks$1(BoxesRunTime.unboxToChar(c))));
    }

    public void main(String[] args) {
        DocumentTest documentTest;
        File schemaFile = new File(args[0]);
        EdiSchema schema = new YamlReader().loadYaml(new InputStreamReader(new FileInputStream(schemaFile)), (List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{args[1]})));
        EdiForm ediForm = schema.ediVersion().ediForm();
        if (X12$.MODULE$.equals(ediForm)) {
            documentTest = new DocumentTestX12(schema, false, false);
        } else if (EdiFact$.MODULE$.equals(ediForm)) {
            documentTest = new DocumentTestEdifact(schema);
        } else {
            throw new IllegalArgumentException("Schema type not supported by test");
        }
        DocumentTestX12 parse = documentTest;
        List examples = (List)((TraversableLike)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).toList().tail()).tail();
        examples.map((Function1<String, Object> & Serializable & scala.Serializable)path -> {
            DocumentTest$.$anonfun$main$1(parse, path);
            return BoxedUnit.UNIT;
        }, List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println("all documents parsed successfully");
    }

    public static final /* synthetic */ boolean $anonfun$stripLineBreaks$1(char c) {
        return c != '\r' && c != '\n';
    }

    public static final /* synthetic */ void $anonfun$main$1(DocumentTest parse$1, String path) {
        FileInputStream is = new FileInputStream(new File(path));
        Map<String, Object> result2 = parse$1.parse(is);
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed document ", ", acknowledgment is:"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{path})));
        Predef$.MODULE$.println(parse$1.printAck(result2));
    }

    private DocumentTest$() {
        MODULE$ = this;
    }
}

