/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model.parameter;

import java.util.List;
import org.raml.model.ParamType;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParam {
    @Scalar
    private String displayName;
    @Scalar
    private String description;
    @Scalar
    private ParamType type;
    @Scalar
    private boolean required;
    @Sequence(alias="enum")
    private List<String> enumeration;
    @Scalar
    private String pattern;
    @Scalar
    private Integer minLength;
    @Scalar
    private Integer maxLength;
    @Scalar
    private Double minimum;
    @Scalar
    private Double maximum;
    @Scalar(alias="default")
    private String defaultValue;
    @Sequence
    private List<String> requires;
    @Scalar
    private String example;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(ParamType type) {
        this.type = type;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ParamType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExample() {
        return this.example;
    }

    public List<String> getEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(List<String> enumeration) {
        this.enumeration = enumeration;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public boolean validate(String value) {
        switch (this.type) {
            case STRING: {
                if (this.pattern != null && !value.matches(this.pattern)) {
                    return false;
                }
                if (this.minLength != null && value.length() < this.minLength) {
                    return false;
                }
                if (this.maxLength != null && value.length() > this.maxLength) {
                    return false;
                }
                if (this.enumeration == null || this.enumeration.contains(value)) break;
                return false;
            }
            case INTEGER: 
            case NUMBER: {
                Double number = Double.valueOf(value);
                if (this.minimum != null && number < this.minimum) {
                    return false;
                }
                if (this.maximum == null || !(number > this.maximum)) break;
                return false;
            }
        }
        return true;
    }
}

