/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.raml.parser.annotation.Key;
import org.raml.parser.annotation.Value;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoTupleBuilder
extends DefaultTupleBuilder<ScalarNode, Node> {
    private Class<?> pojoClass;
    private String fieldName;

    public PojoTupleBuilder(String fieldName, Class<?> pojoClass) {
        super(new DefaultScalarTupleHandler(MappingNode.class, fieldName));
        this.fieldName = fieldName;
        this.pojoClass = pojoClass;
    }

    public PojoTupleBuilder(Class<?> pojoClass) {
        this(null, pojoClass);
    }

    @Override
    public NodeBuilder getBuilderForTuple(NodeTuple tuple) {
        if (this.builders.isEmpty()) {
            this.addBuildersFor(this.pojoClass);
        }
        return super.getBuilderForTuple(tuple);
    }

    @Override
    public Object buildValue(Object parent, Node node) {
        try {
            Object newValue;
            Constructor<?>[] declaredConstructors = this.pojoClass.getDeclaredConstructors();
            if (declaredConstructors.length > 0) {
                Annotation[][] parameterAnnotations;
                ArrayList<Object> arguments = new ArrayList<Object>();
                Constructor<?> declaredConstructor = declaredConstructors[0];
                for (Annotation[] parameterAnnotation : parameterAnnotations = declaredConstructor.getParameterAnnotations()) {
                    if (parameterAnnotation[0].annotationType().equals(Value.class)) {
                        arguments.add(NodeUtils.getNodeValue(node));
                        continue;
                    }
                    if (!parameterAnnotation[0].annotationType().equals(Key.class)) continue;
                    arguments.add(this.fieldName);
                }
                newValue = declaredConstructor.newInstance(arguments.toArray(new Object[arguments.size()]));
            } else {
                newValue = this.pojoClass.newInstance();
            }
            ReflectionUtils.setProperty(parent, this.fieldName, newValue);
            this.processPojoAnnotations(newValue, this.fieldName, parent);
            return newValue;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildKey(Object parent, ScalarNode node) {
        this.fieldName = node.getValue();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getPojoClass() {
        return this.pojoClass;
    }

    public String toString() {
        return this.fieldName;
    }
}

