/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.List;
import java.util.Map;
import org.mule.module.apikit.uri.Parameters;
import org.mule.module.apikit.uri.TokenBase;
import org.mule.module.apikit.uri.TokenOperator;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URITemplateSyntaxException;
import org.mule.module.apikit.uri.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenOperatorD3
extends TokenBase
implements TokenOperator {
    private Operator _operator;
    private String _arg;
    private List<Variable> _vars;

    public TokenOperatorD3(Operator op, String arg, List<Variable> vars) throws NullPointerException {
        super(TokenOperatorD3.toExpression(op, arg, vars));
        if (op == null || arg == null || vars == null) {
            throw new NullPointerException("The operator must have a value");
        }
        this._operator = op;
        this._arg = arg;
        this._vars = vars;
    }

    @Override
    public String expand(Parameters parameters) {
        return this._operator.expand(this._arg, this._vars, parameters);
    }

    public Operator operator() {
        return this._operator;
    }

    public String argument() {
        return this._arg;
    }

    @Override
    public List<Variable> variables() {
        return this._vars;
    }

    public static Operator toOperator(String op) {
        for (Operator o : Operator.values()) {
            if (!o.name().toLowerCase().equals(op)) continue;
            return o;
        }
        return null;
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        return false;
    }

    public static TokenOperatorD3 parse(String exp) throws URITemplateSyntaxException {
        String sexp = TokenOperatorD3.strip(exp);
        String[] parts = sexp.split("\\|");
        if (parts.length != 3) {
            throw new URITemplateSyntaxException(sexp, "An operator expansion must has three parts");
        }
        String op = parts[0];
        String arg = parts[1];
        String vars = parts[2];
        if (!op.startsWith("-")) {
            throw new URITemplateSyntaxException(op, "An operator must start with '-'");
        }
        Operator operator = TokenOperatorD3.toOperator(op.substring(1));
        if (operator == null) {
            throw new URITemplateSyntaxException(op, "This operator is not supported");
        }
        List<Variable> variables = TokenOperatorD3.toVariables(vars);
        return new TokenOperatorD3(operator, arg, variables);
    }

    private static String toExpression(Operator op, String arg, List<Variable> vars) {
        StringBuffer exp = new StringBuffer();
        exp.append('{');
        exp.append(op.name().toLowerCase());
        exp.append('|');
        exp.append(arg);
        exp.append('|');
        for (Variable v : vars) {
            exp.append(v.toString());
        }
        exp.append('}');
        return exp.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        OPT{

            @Override
            public String expand(String arg, List<Variable> vars, Parameters parameters) {
                for (Variable v : vars) {
                    if (!parameters.exists(v.name())) continue;
                    return arg;
                }
                return "";
            }
        }
        ,
        NEG{

            @Override
            String expand(String arg, List<Variable> vars, Parameters parameters) {
                for (Variable v : vars) {
                    if (!parameters.exists(v.name())) continue;
                    return "";
                }
                return arg;
            }
        }
        ,
        PREFIX{

            @Override
            String expand(String arg, List<Variable> vars, Parameters parameters) {
                StringBuffer expansion = new StringBuffer();
                Variable var = vars.get(0);
                String[] values = var.values(parameters);
                if (values.length > 0 && values[0].length() > 0) {
                    for (String value : values) {
                        expansion.append(arg).append(URICoder.encode(value));
                    }
                }
                return expansion.toString();
            }
        }
        ,
        SUFFIX{

            @Override
            String expand(String arg, List<Variable> vars, Parameters parameters) {
                StringBuffer expansion = new StringBuffer();
                Variable var = vars.get(0);
                String[] values = var.values(parameters);
                if (values.length > 0 && values[0].length() > 0) {
                    for (String value : values) {
                        expansion.append(URICoder.encode(value)).append(arg);
                    }
                }
                return expansion.toString();
            }
        }
        ,
        JOIN{

            @Override
            String expand(String arg, List<Variable> vars, Parameters parameters) {
                StringBuffer expansion = new StringBuffer();
                boolean first = true;
                for (Variable var : vars) {
                    String[] values;
                    if (!parameters.exists(var.name())) continue;
                    for (String value : values = var.values(parameters)) {
                        if (!first) {
                            expansion.append(arg);
                        } else {
                            first = false;
                        }
                        expansion.append(var.name()).append('=').append(URICoder.encode(value));
                    }
                }
                return expansion.toString();
            }
        }
        ,
        LIST{

            @Override
            String expand(String arg, List<Variable> vars, Parameters parameters) {
                StringBuffer expansion = new StringBuffer();
                Variable var = vars.get(0);
                String[] values = var.values(parameters);
                if (values.length > 0 && values[0].length() > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            expansion.append(arg);
                        }
                        expansion.append(URICoder.encode(values[i]));
                    }
                }
                return expansion.toString();
            }
        };


        abstract String expand(String var1, List<Variable> var2, Parameters var3);
    }
}

