/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import org.raml.model.parameter.AbstractParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParamType {
    STRING{

        public boolean validate(AbstractParam param, String value) {
            if (param.getPattern() != null && !value.matches(param.getPattern())) {
                return false;
            }
            if (param.getMinLength() != null && value.length() < param.getMinLength()) {
                return false;
            }
            if (param.getMaxLength() != null && value.length() > param.getMaxLength()) {
                return false;
            }
            return param.getEnumeration() == null || param.getEnumeration().contains(value);
        }
    }
    ,
    NUMBER{

        public boolean validate(AbstractParam param, String value) {
            Double number;
            try {
                number = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (param.getMinimum() != null && number < param.getMinimum()) {
                return false;
            }
            return param.getMaximum() == null || !(number > param.getMaximum());
        }
    }
    ,
    INTEGER{

        public boolean validate(AbstractParam param, String value) {
            Integer number;
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (param.getMinimum() != null && (double)number.intValue() < param.getMinimum()) {
                return false;
            }
            return param.getMaximum() == null || !((double)number.intValue() > param.getMaximum());
        }
    }
    ,
    DATE,
    FILE,
    BOOLEAN{

        public boolean validate(AbstractParam param, String value) {
            return "true".equals(value) || "false".equals(value);
        }
    };


    public boolean validate(AbstractParam param, String value) {
        return true;
    }
}

