/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayList;
import java.util.List;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumModifierRule
extends SimpleRule {
    private SimpleRule enumRule;
    private List<String> enumTypes;

    public EnumModifierRule(String ruleName, List<String> enumTypes, SimpleRule enumRule) {
        super(ruleName, Integer.class);
        this.enumTypes = enumTypes;
        this.enumRule = enumRule;
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        ScalarNode enumValueNode = this.enumRule.getValueNode();
        String messageTypes = this.generateMessageTypes();
        if (enumValueNode == null) {
            validationResults.add(ValidationResult.createErrorResult(this.enumRule.getName() + " must exist first, and it must be of type" + messageTypes, key.getStartMark(), key.getEndMark()));
        }
        if (enumValueNode != null && !this.enumTypes.contains(this.enumRule.getValueNode().getValue())) {
            validationResults.add(ValidationResult.createErrorResult(this.enumRule.getName() + " must be of type" + messageTypes, key.getStartMark(), key.getEndMark()));
        }
        validationResults.addAll(super.validateKey(key));
        if (ValidationResult.areValid(validationResults)) {
            this.setKeyNode(key);
        }
        return validationResults;
    }

    private String generateMessageTypes() {
        StringBuilder types = new StringBuilder();
        for (int i = 0; i < this.enumTypes.size() - 1; ++i) {
            types.append(" " + this.enumTypes.get(i) + " or");
        }
        types.append(" " + this.enumTypes.get(this.enumTypes.size() - 1));
        return types.toString();
    }

    @Override
    public List<ValidationResult> doValidateValue(ScalarNode value) {
        String valueNode = value.getValue();
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        try {
            Integer.parseInt(valueNode);
        }
        catch (NumberFormatException nfe) {
            validationResults.add(ValidationResult.createErrorResult(this.getName() + " can only contain integer values greater than zero", value.getStartMark(), value.getEndMark()));
        }
        validationResults.addAll(super.doValidateValue(value));
        return validationResults;
    }
}

