/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.YamlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlValidationService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ValidationResult> errorMessage;
    private YamlValidator yamlValidator;
    private ResourceLoader resourceLoader;
    private TagResolver[] tagResolvers;

    protected YamlValidationService(ResourceLoader resourceLoader, YamlValidator yamlValidator, TagResolver[] tagResolvers) {
        this.resourceLoader = resourceLoader;
        this.yamlValidator = yamlValidator;
        this.errorMessage = new ArrayList<ValidationResult>();
        this.tagResolvers = tagResolvers;
    }

    public List<ValidationResult> validate(String content) {
        long startTime = System.currentTimeMillis();
        Yaml yamlParser = new Yaml();
        try {
            NodeVisitor nodeVisitor = new NodeVisitor(this.yamlValidator, this.resourceLoader, this.tagResolvers);
            Node root = yamlParser.compose((Reader)new StringReader(content));
            this.errorMessage.addAll(this.preValidation((MappingNode)root));
            if (this.errorMessage.isEmpty() && root.getNodeId() == NodeId.mapping) {
                nodeVisitor.visitDocument((MappingNode)root);
            }
        }
        catch (MarkedYAMLException mye) {
            this.errorMessage.add(ValidationResult.createErrorResult(mye.getProblem(), mye.getProblemMark(), null));
        }
        catch (YAMLException ex) {
            this.errorMessage.add(ValidationResult.createErrorResult(ex.getMessage()));
        }
        this.errorMessage.addAll(this.yamlValidator.getMessages());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("validation time: " + (System.currentTimeMillis() - startTime) + "ms.");
        }
        return this.errorMessage;
    }

    protected List<ValidationResult> preValidation(MappingNode root) {
        return new ArrayList<ValidationResult>();
    }
}

