/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.JsonLoader;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.registry.RegistrationException;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRestSchemaValidator;
import org.mule.module.apikit.validation.cache.JsonSchemaAndNode;
import org.mule.module.apikit.validation.cache.JsonSchemaCache;
import org.raml.model.Raml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestJsonSchemaValidator
extends AbstractRestSchemaValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RestJsonSchemaValidator(MuleContext muleContext) {
        super(muleContext);
    }

    public void validate(String schemaPath, MuleEvent muleEvent, Raml api) throws BadRequestException {
        try {
            JsonNode data;
            Object input = muleEvent.getMessage().getPayload();
            if (input instanceof InputStream) {
                input = IOUtils.toString((InputStream)((InputStream)input));
                this.logger.debug("transforming payload to perform JSON Schema validation");
                muleEvent.getMessage().setPayload(input);
            }
            if (input instanceof String) {
                data = JsonLoader.fromReader((Reader)new StringReader((String)input));
            } else if (input instanceof byte[]) {
                data = JsonLoader.fromReader((Reader)new InputStreamReader(new ByteArrayInputStream((byte[])input)));
            } else {
                throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
            }
            JsonSchemaAndNode schema = (JsonSchemaAndNode)JsonSchemaCache.getJsonSchemaCache(this.muleContext, api).get((Object)schemaPath);
            ValidationReport report = schema.getJsonSchema().validate(data);
            if (!report.isSuccess()) {
                String message = (String)report.getMessages().get(0);
                this.logger.info("Schema validation failed: " + message);
                throw new BadRequestException(message);
            }
        }
        catch (ExecutionException e) {
            throw new BadRequestException(e);
        }
        catch (RegistrationException e) {
            throw new BadRequestException(e);
        }
        catch (IOException e) {
            throw new BadRequestException(e);
        }
    }
}

