/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.util.ArrayList;
import org.raml.parser.builder.MapTupleBuilder;
import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.SequenceTupleBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapWithListValueTupleBuilder
extends MapTupleBuilder {
    public MapWithListValueTupleBuilder(String fieldName, Class<?> valueClass) {
        super(fieldName, valueClass);
    }

    @Override
    public TupleBuilder getBuilderForTuple(NodeTuple tuple) {
        String fieldName = ((ScalarNode)tuple.getKeyNode()).getValue();
        if (tuple.getValueNode() instanceof SequenceNode) {
            return new SequenceTupleBuilder(fieldName, this.getValueClass());
        }
        return new ListOfPojoTupleBuilder(fieldName, this.getValueClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListOfPojoTupleBuilder
    extends PojoTupleBuilder {
        public ListOfPojoTupleBuilder(String fieldName, Class<?> pojoClass) {
            super(fieldName, pojoClass);
        }

        @Override
        public Object buildValue(Object parent, Node node) {
            try {
                Object newValue = ReflectionUtils.isPojo(this.getPojoClass()) ? this.getPojoClass().newInstance() : NodeUtils.getNodeValue(node);
                ArrayList<Object> objects = new ArrayList<Object>();
                objects.add(newValue);
                ReflectionUtils.setProperty(parent, this.getFieldName(), objects);
                this.processPojoAnnotations(newValue, this.getFieldName(), parent);
                return newValue;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

