/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Stack;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.SequenceRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.visitor.IncludeInfo;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlValidator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDocumentValidator
implements YamlValidator {
    private Class<?> documentClass;
    private Stack<NodeRule<?>> ruleContext = new Stack();
    private Deque<IncludeInfo> includeContext = new ArrayDeque<IncludeInfo>();
    private List<ValidationResult> messages = new ArrayList<ValidationResult>();
    private NodeRuleFactory nodeRuleFactory;

    protected YamlDocumentValidator(Class<?> documentClass) {
        this(documentClass, new NodeRuleFactory(new NodeRuleFactoryExtension[0]));
    }

    protected YamlDocumentValidator(Class<?> documentClass, NodeRuleFactory nodeRuleFactory) {
        this.documentClass = documentClass;
        this.nodeRuleFactory = nodeRuleFactory;
    }

    protected Stack<NodeRule<?>> getRuleContext() {
        return this.ruleContext;
    }

    @Override
    public void onMappingNodeStart(MappingNode node, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            this.addMessage(ValidationResult.createErrorResult("Only scalar keys are allowed", (Node)node));
        }
    }

    @Override
    public void onMappingNodeEnd(MappingNode node, TupleType tupleType) {
    }

    @Override
    public void onSequenceStart(SequenceNode node, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            this.addMessage(ValidationResult.createErrorResult("Only scalar keys are allowed", (Node)node));
        } else {
            NodeRule<?> peek = this.ruleContext.peek();
            this.addMessages(peek.validateValue(node));
        }
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        NodeRule<?> peek = this.ruleContext.peek();
        List<ValidationResult> result = tupleType == TupleType.VALUE ? peek.validateValue(node) : ((TupleRule)peek).validateKey(node);
        this.addMessages(result);
    }

    private void addMessages(List<ValidationResult> result) {
        for (ValidationResult validationResult : result) {
            validationResult.addIncludeContext(this.includeContext);
            this.messages.add(validationResult);
        }
    }

    private void addMessage(ValidationResult errorResult) {
        this.addMessages(Collections.singletonList(errorResult));
    }

    @Override
    public void onDocumentStart(MappingNode node) {
        this.ruleContext.push(this.buildDocumentRule());
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        NodeRule<?> pop = this.ruleContext.pop();
        List<ValidationResult> onRuleEnd = pop.onRuleEnd();
        this.addMessages(onRuleEnd);
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        NodeRule<?> rule = this.ruleContext.pop();
        if (rule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        List<ValidationResult> onRuleEnd = rule.onRuleEnd();
        this.addMessages(onRuleEnd);
    }

    @Override
    public void onTupleStart(NodeTuple nodeTuple) {
        TupleRule tupleRule = (TupleRule)this.ruleContext.peek();
        if (tupleRule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        TupleRule<?, ?> rule = tupleRule.getRuleForTuple(nodeTuple);
        this.ruleContext.push(rule);
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
        NodeRule<?> peek = this.ruleContext.peek();
        if (!(peek instanceof SequenceRule)) {
            this.ruleContext.push(peek);
        } else {
            this.ruleContext.push(((SequenceRule)((Object)peek)).getItemRule());
        }
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
        NodeRule<?> rule = this.ruleContext.pop();
        List<ValidationResult> validationResults = rule.onRuleEnd();
        this.addMessages(validationResults);
    }

    @Override
    public void onCustomTagStart(Tag tag, Node originalValueNode, NodeTuple nodeTuple) {
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag) && originalValueNode.getNodeId() == NodeId.scalar) {
            this.includeContext.push(new IncludeInfo((ScalarNode)originalValueNode));
        } else if (tag.startsWith("!include-applied_")) {
            this.includeContext.push(new IncludeInfo(tag));
        }
    }

    @Override
    public void onCustomTagEnd(Tag tag, Node originalValueNode, NodeTuple nodeTuple) {
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag) && originalValueNode.getNodeId() == NodeId.scalar || tag.startsWith("!include-applied_")) {
            this.includeContext.pop();
        }
    }

    @Override
    public void onCustomTagError(Tag tag, Node node, String message) {
        this.addMessages(Arrays.asList(ValidationResult.createErrorResult(message, node.getStartMark(), node.getEndMark())));
    }

    private DefaultTupleRule<Node, MappingNode> buildDocumentRule() {
        return this.nodeRuleFactory.createDocumentRule(this.documentClass);
    }

    @Override
    public List<ValidationResult> getMessages() {
        return this.messages;
    }
}

