/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class RegexFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new RegexFormatAttribute();

    private RegexFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        if (RhinoHelper.regexIsValid(value.textValue())) {
            return;
        }
        Message.Builder msg = RegexFormatAttribute.newMsg(fmt).setMessage("string is not a valid ECMA 262 regular expression").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

