/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class PropertiesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new PropertiesSyntaxChecker();

    private PropertiesSyntaxChecker() {
        super("properties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        SortedMap<String, JsonNode> map = JacksonUtils.nodeToTreeMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            msg.addInfo("key", entry.getKey());
            JsonNode value = entry.getValue();
            NodeType type = NodeType.getNodeType(entry.getValue());
            if (!value.isObject()) {
                msg.setMessage("key value has incorrect type").addInfo("expected", NodeType.OBJECT).addInfo("found", type);
                messages.add(msg.build());
                continue;
            }
            if (!value.has("required") || (type = NodeType.getNodeType(value.get("required"))) == NodeType.BOOLEAN) continue;
            msg.setMessage("\"required\" attribute has incorrect type").addInfo("expected", NodeType.BOOLEAN).addInfo("found", type);
            messages.add(msg.build());
        }
    }
}

