/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.ref.SchemaContainer;
import org.eel.kitchen.jsonschema.ref.SchemaNode;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.validator.ArrayValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ObjectValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

final class InstanceValidator
implements JsonValidator {
    private final SchemaNode schemaNode;
    private final Set<KeywordValidator> validators;

    InstanceValidator(SchemaNode schemaNode, Set<KeywordValidator> validators) {
        this.validators = ImmutableSet.copyOf(validators);
        this.schemaNode = schemaNode;
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        SchemaContainer orig = context.getContainer();
        context.setContainer(this.schemaNode.getContainer());
        for (KeywordValidator validator : this.validators) {
            validator.validateInstance(context, report, instance);
            if (!report.hasFatalError()) continue;
            return;
        }
        if (instance.size() > 0 && report.isSuccess()) {
            JsonValidator validator = instance.isArray() ? new ArrayValidator(this.schemaNode.getNode()) : new ObjectValidator(this.schemaNode.getNode());
            validator.validate(context, report, instance);
        }
        context.setContainer(orig);
    }
}

