/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.construct.Flow;
import org.mule.module.apikit.ActionImplementedRuleExtension;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.raml.emitter.RamlEmitter;
import org.raml.model.Raml;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String raml;
    private boolean consoleEnabled;
    private String consolePath;
    private boolean disableValidations;
    private List<FlowMapping> flowMappings = new ArrayList<FlowMapping>();
    private FlowConstruct flowConstruct;
    private Raml api;
    private String apikitRaml;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRaml() {
        return this.raml;
    }

    public void setRaml(String raml) {
        this.raml = raml;
    }

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public void setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
    }

    public String getConsolePath() {
        return this.consolePath;
    }

    public void setConsolePath(String consolePath) {
        this.consolePath = consolePath;
    }

    public boolean isDisableValidations() {
        return this.disableValidations;
    }

    public void setDisableValidations(boolean disableValidations) {
        this.disableValidations = disableValidations;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public void setFlowMappings(List<FlowMapping> flowMappings) {
        this.flowMappings = flowMappings;
    }

    public Raml getApi() {
        return this.api;
    }

    public String getApikitRaml() {
        return this.apikitRaml;
    }

    public void loadApiDefinition(MuleContext muleContext, FlowConstruct flowConstruct, Map<String, Flow> restFlowMap) {
        String ramlBuffer;
        InputStream ramlStream;
        this.flowConstruct = flowConstruct;
        DefaultResourceLoader loader = new DefaultResourceLoader();
        String appHome = (String)muleContext.getRegistry().get("app.home");
        if (appHome != null) {
            loader = new CompositeResourceLoader(new ResourceLoader[]{new FileResourceLoader(appHome), loader});
        }
        if ((ramlStream = loader.fetchResource(this.getRaml())) == null) {
            throw new ApikitRuntimeException(String.format("API descriptor %s not found", this.getRaml()));
        }
        try {
            ramlBuffer = IOUtils.toString((InputStream)ramlStream);
        }
        catch (IOException e) {
            throw new ApikitRuntimeException(String.format("Cannot read API descriptor %s", this.getRaml()));
        }
        this.validateRaml(ramlBuffer, (ResourceLoader)loader, restFlowMap);
        RamlDocumentBuilder builder = new RamlDocumentBuilder((ResourceLoader)loader, new TagResolver[0]);
        this.api = (Raml)builder.build(ramlBuffer);
        this.injectEndpointUri(builder);
        this.apikitRaml = new RamlEmitter().dump(this.api);
    }

    protected void validateRaml(String ramlBuffer, ResourceLoader resourceLoader, Map<String, Flow> restFlowMap) {
        NodeRuleFactory ruleFactory = new NodeRuleFactory(new NodeRuleFactoryExtension[]{new ActionImplementedRuleExtension(restFlowMap)});
        List results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (NodeRuleFactory)ruleFactory, (TagResolver[])new TagResolver[0]).validate(ramlBuffer);
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, (List)results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new ApikitRuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, (List)results);
        if (!warnings.isEmpty()) {
            this.logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.getRaml());
            if (result.getLine() != ValidationResult.UNKNOWN) {
                sb.append(" -- line ");
                sb.append(result.getLine());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void injectEndpointUri(RamlDocumentBuilder builder) {
        String address = this.getEndpointAddress(this.flowConstruct);
        this.api.setBaseUri(address);
        ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
        boolean baseUriPresent = false;
        for (NodeTuple tuple : builder.getRootNode().getValue()) {
            if (((ScalarNode)tuple.getKeyNode()).getValue().equals("baseUri")) {
                ScalarNode valueNode = (ScalarNode)tuple.getValueNode();
                tuples.add(new NodeTuple(tuple.getKeyNode(), (Node)new ScalarNode(valueNode.getTag(), address, valueNode.getStartMark(), valueNode.getEndMark(), valueNode.getStyle())));
                baseUriPresent = true;
                continue;
            }
            tuples.add(tuple);
        }
        if (!baseUriPresent) {
            ScalarNode keyNode = new ScalarNode(Tag.STR, "baseUri", null, null, Character.valueOf('0'));
            ScalarNode valueNode = new ScalarNode(Tag.STR, address, null, null, Character.valueOf('0'));
            tuples.add(new NodeTuple((Node)keyNode, (Node)valueNode));
        }
        builder.getRootNode().setValue(tuples);
    }

    public String getEndpointAddress(FlowConstruct flowConstruct) {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((Flow)flowConstruct).getMessageSource();
        String address = endpoint.getAddress();
        String path = endpoint.getEndpointURI().getPath();
        String scheme = endpoint.getEndpointURI().getScheme();
        String chAddress = System.getProperty("fullDomain");
        String chBaseUri = scheme + "://" + chAddress + path;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("yaml baseUri: " + this.api.getBaseUri());
            this.logger.debug("mule baseUri: " + address);
            this.logger.debug("chub baseUri: " + chBaseUri);
        }
        if (chAddress != null) {
            address = chBaseUri;
        }
        if (address.endsWith("/")) {
            this.logger.debug("removing trailing slash from baseuri -> " + address);
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }
}

