/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.construct.Flow;
import org.mule.module.apikit.ActionImplementedRuleExtension;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.util.BeanUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.raml.emitter.RamlEmitter;
import org.raml.model.Raml;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    public static final String BIND_ALL_HOST = "0.0.0.0";
    public static final String DEFAULT_CONSOLE_PATH = "console";
    private static final String CONSOLE_URL_FILE = "consoleurl";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String raml;
    private boolean consoleEnabled = true;
    private String consolePath = "console";
    private boolean disableValidations;
    private List<FlowMapping> flowMappings = new ArrayList<FlowMapping>();
    private FlowConstruct flowConstruct;
    private MuleContext muleContext;
    private Raml api;
    private String baseHost;
    private Map<String, String> apikitRaml = new ConcurrentHashMap<String, String>();
    private List<String> consoleUrls = new ArrayList<String>();
    private Map<String, Flow> restFlowMap;
    private boolean started;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRaml() {
        return this.raml;
    }

    public void setRaml(String raml) {
        this.raml = raml;
    }

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    public void setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
    }

    public String getConsolePath() {
        return this.consolePath;
    }

    public void setConsolePath(String consolePath) {
        this.consolePath = consolePath;
    }

    public boolean isDisableValidations() {
        return this.disableValidations;
    }

    public void setDisableValidations(boolean disableValidations) {
        this.disableValidations = disableValidations;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public void setFlowMappings(List<FlowMapping> flowMappings) {
        this.flowMappings = flowMappings;
    }

    public Raml getApi() {
        return this.api;
    }

    public String getApikitRaml(String host) {
        if (!BIND_ALL_HOST.equals(this.baseHost)) {
            return this.apikitRaml.get(this.baseHost);
        }
        String hostRaml = this.apikitRaml.get(host);
        if (hostRaml == null) {
            Raml clone;
            try {
                clone = (Raml)BeanUtils.cloneBean((Object)this.api);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            clone.setBaseUri(this.api.getBaseUri().replace(this.baseHost, host));
            hostRaml = new RamlEmitter().dump(clone);
            this.apikitRaml.put(host, hostRaml);
        }
        return hostRaml;
    }

    public void loadApiDefinition(MuleContext muleContext, FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        this.muleContext = muleContext;
        DefaultResourceLoader loader = new DefaultResourceLoader();
        String appHome = (String)muleContext.getRegistry().get("app.home");
        if (appHome != null) {
            loader = new CompositeResourceLoader(new ResourceLoader[]{new FileResourceLoader(appHome), loader});
        }
        this.initializeRestFlowMap();
        this.validateRaml((ResourceLoader)loader);
        RamlDocumentBuilder builder = new RamlDocumentBuilder((ResourceLoader)loader, new TagResolver[0]);
        this.api = (Raml)builder.build(this.getRaml());
        this.injectEndpointUri();
        this.flowMappings = new ArrayList<FlowMapping>();
        this.apikitRaml = new ConcurrentHashMap<String, String>();
        this.apikitRaml.put(this.baseHost, new RamlEmitter().dump(this.api));
    }

    protected void validateRaml(ResourceLoader resourceLoader) {
        NodeRuleFactory ruleFactory = new NodeRuleFactory(new NodeRuleFactoryExtension[]{new ActionImplementedRuleExtension(this.restFlowMap)});
        List results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (NodeRuleFactory)ruleFactory, (TagResolver[])new TagResolver[0]).validate(this.getRaml());
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, (List)results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new ApikitRuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, (List)results);
        if (!warnings.isEmpty()) {
            this.logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.getRaml());
            if (result.getLine() != ValidationResult.UNKNOWN) {
                sb.append(" -- line ");
                sb.append(result.getLine());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void injectEndpointUri() {
        String address = this.getEndpointAddress(this.flowConstruct);
        this.api.setBaseUri(address);
        try {
            this.baseHost = new URI(address).getHost();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEndpointAddress(FlowConstruct flowConstruct) {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((Flow)flowConstruct).getMessageSource();
        String address = endpoint.getAddress();
        String path = endpoint.getEndpointURI().getPath();
        String scheme = endpoint.getEndpointURI().getScheme();
        String chAddress = System.getProperty("fullDomain");
        String chBaseUri = scheme + "://" + chAddress + path;
        if (this.logger.isDebugEnabled()) {
            if (this.api != null) {
                this.logger.debug("yaml baseUri: " + this.api.getBaseUri());
            }
            this.logger.debug("mule baseUri: " + address);
            this.logger.debug("chub baseUri: " + chBaseUri);
        }
        if (chAddress != null) {
            address = chBaseUri;
        }
        if (address.endsWith("/")) {
            this.logger.debug("removing trailing slash from baseuri -> " + address);
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }

    public void addConsoleUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            this.consoleUrls.add(url);
        }
    }

    public void publishConsoleUrls(String parentDirectory) {
        this.started = true;
        if (this.isLastRouterToStart()) {
            this.dumpUrlsFile(parentDirectory);
        }
        if (this.logger.isInfoEnabled()) {
            for (String consoleUrl : this.consoleUrls) {
                String msg = String.format("APIKit Console URL: %s", consoleUrl);
                this.logger.info(StringMessageUtils.getBoilerPlate((String)msg));
            }
        }
    }

    private boolean isLastRouterToStart() {
        Collection configurations = this.muleContext.getRegistry().lookupObjects(Configuration.class);
        for (Configuration configuration : configurations) {
            if (configuration.started) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUrlsFile(String parentDirectory) {
        File urlFile = new File(parentDirectory, CONSOLE_URL_FILE);
        FileWriter writer = null;
        try {
            if (!urlFile.exists()) {
                urlFile.createNewFile();
            }
            writer = new FileWriter(urlFile, true);
            for (String consoleUrl : this.getAllConsoleUrls()) {
                writer.write(consoleUrl + "\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                this.logger.error("cannot publish console url for studio", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private List<String> getAllConsoleUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        Collection configurations = this.muleContext.getRegistry().lookupObjects(Configuration.class);
        for (Configuration configuration : configurations) {
            urls.addAll(configuration.consoleUrls);
        }
        return urls;
    }

    private void initializeRestFlowMap() {
        if (this.restFlowMap == null) {
            this.restFlowMap = new HashMap<String, Flow>();
            Collection flows = this.muleContext.getRegistry().lookupObjects(Flow.class);
            for (Flow flow : flows) {
                String key = this.getRestFlowKey(flow.getName());
                if (key == null) continue;
                this.restFlowMap.put(key, flow);
            }
            for (FlowMapping mapping : this.getFlowMappings()) {
                this.restFlowMap.put(mapping.getAction() + ":" + mapping.getResource(), mapping.getFlow());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("==== RestFlows defined:");
                for (String key : this.restFlowMap.keySet()) {
                    this.logger.debug("\t\t" + key);
                }
            }
        }
    }

    public Map<String, Flow> getRestFlowMap() {
        return this.restFlowMap;
    }

    private String getRestFlowKey(String name) {
        String[] coords = name.split(":");
        String[] methods = new String[]{"get", "put", "post", "delete", "head", "patch", "options"};
        if (coords.length < 2 || !Arrays.asList(methods).contains(coords[0])) {
            return null;
        }
        if (coords.length == 3 && !coords[2].equals(this.getName())) {
            return null;
        }
        return coords[0] + ":" + coords[1];
    }
}

