/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.InvalidUriParameterException;
import org.mule.module.apikit.exception.MethodNotAllowedException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.uri.ResolvedVariables;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.URIResolver;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements MessageProcessor,
Startable,
MuleContextAware,
FlowConstructAware {
    private static final int URI_CACHE_SIZE = 1000;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private Configuration config;
    private Map<URIPattern, Resource> routingTable;
    private LoadingCache<String, URIResolver> uriResolverCache;
    private LoadingCache<String, URIPattern> uriPatternCache;
    private ConsoleHandler consoleHandler;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    private Raml getApi() {
        return this.getConfig().getApi();
    }

    private String getRaml(String host) {
        return this.getConfig().getApikitRaml(host);
    }

    public void start() throws MuleException {
        if (this.flowConstruct == null) {
            return;
        }
        if (this.config == null) {
            try {
                this.config = (Configuration)this.muleContext.getRegistry().lookupObject(Configuration.class);
            }
            catch (RegistrationException e) {
                throw new StartException(MessageFactory.createStaticMessage((String)"APIKit configuration not Found"), (Startable)this);
            }
        }
        this.config.loadApiDefinition(this.muleContext, this.flowConstruct);
        if (this.config.isConsoleEnabled()) {
            this.consoleHandler = new ConsoleHandler(this.getApi().getBaseUri(), this.config.getConsolePath());
            this.config.addConsoleUrl(this.consoleHandler.getConsoleUrl());
        }
        this.routingTable = new HashMap<URIPattern, Resource>();
        this.buildRoutingTable(this.getApi().getResources());
        this.logger.info("Building resource URI cache...");
        this.uriResolverCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIResolver>(){

            public URIResolver load(String path) throws IOException {
                return new URIResolver(URICoder.encode(path, '/'));
            }
        });
        this.uriPatternCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIPattern>(){

            public URIPattern load(String path) throws Exception {
                URIResolver resolver = (URIResolver)Router.this.uriResolverCache.get((Object)path);
                Collection<URIPattern> matches = resolver.findAll(Router.this.routingTable.keySet());
                if (matches.size() == 0) {
                    Router.this.logger.warn("No matching patterns for URI " + path);
                    throw new NotFoundException(path);
                }
                if (Router.this.logger.isDebugEnabled()) {
                    Router.this.logger.debug(matches.size() + " matching patterns for URI " + path + ". Finding best one...");
                }
                for (URIPattern p : matches) {
                    boolean best = p == resolver.find(Router.this.routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
                    if (!best) continue;
                    return p;
                }
                return null;
            }
        });
        this.config.publishConsoleUrls(this.muleContext.getConfiguration().getWorkingDirectory());
    }

    private void buildRoutingTable(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            String parentUri = resource.getParentUri();
            if (parentUri.contains("{version}")) {
                resource.setParentUri(parentUri.replaceAll("\\{version}", this.getApi().getVersion()));
            }
            String uri = resource.getUri();
            this.logger.debug("Adding URI to the routing table: " + uri);
            this.routingTable.put(new URIPattern(uri), resource);
            if (resource.getResources() == null) continue;
            this.buildRoutingTable(resource.getResources());
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        URIResolver uriResolver;
        URIPattern uriPattern;
        HttpRestRequest request = new HttpRestRequest(event, this.getConfig());
        String path = request.getResourcePath();
        if (this.config.isConsoleEnabled() && path.startsWith(this.getApi().getUri() + "/" + this.config.getConsolePath())) {
            return this.consoleHandler.process(event);
        }
        if (path.equals(this.getApi().getUri()) && ActionType.GET.toString().equals(request.getMethod().toUpperCase()) && request.getAdapter().getAcceptableResponseMediaTypes().contains("application/raml+yaml")) {
            String host = (String)event.getMessage().getInboundProperty("host");
            if (host.contains(":")) {
                host = host.split(":")[0];
            }
            String raml = this.getRaml(host);
            event.getMessage().setPayload((Object)raml);
            event.getMessage().setOutboundProperty("Content-Type", (Object)"application/raml+yaml");
            event.getMessage().setOutboundProperty("Content-Length", (Object)raml.length());
            event.getMessage().setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            return event;
        }
        try {
            uriPattern = (URIPattern)this.uriPatternCache.get((Object)path);
            uriResolver = (URIResolver)this.uriResolverCache.get((Object)path);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MuleRestException) {
                throw (MuleRestException)((Object)e.getCause());
            }
            throw new DefaultMuleException((Throwable)e);
        }
        Resource resource = this.routingTable.get(uriPattern);
        if (resource.getAction(request.getMethod()) == null) {
            throw new MethodNotAllowedException(resource.getUri(), request.getMethod());
        }
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        this.processUriParameters(resolvedVariables, resource, event);
        Flow flow = this.getFlow(resource, request.getMethod());
        if (flow == null) {
            throw new ApikitRuntimeException("Flow not found for resource: " + resource);
        }
        return request.process(flow, resource.getAction(request.getMethod()));
    }

    private void processUriParameters(ResolvedVariables resolvedVariables, Resource resource, MuleEvent event) throws InvalidUriParameterException {
        if (this.logger.isDebugEnabled()) {
            for (String name : resolvedVariables.names()) {
                this.logger.debug("        uri parameter: " + name + "=" + resolvedVariables.get(name));
            }
        }
        if (!this.config.isDisableValidations()) {
            for (String key : resource.getUriParameters().keySet()) {
                String value = (String)resolvedVariables.get(key);
                if (((UriParameter)resource.getUriParameters().get(key)).validate(value)) continue;
                throw new InvalidUriParameterException("Invalid uri parameter value " + value + " for " + key);
            }
        }
        for (String name : resolvedVariables.names()) {
            event.getMessage().setInvocationProperty(name, resolvedVariables.get(name));
        }
    }

    private Flow getFlow(Resource resource, String method) {
        return this.config.getRestFlowMap().get(method + ":" + resource.getUri());
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

