/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.StartException;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.ApiRouter;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.InvalidUriParameterException;
import org.mule.module.apikit.exception.MethodNotAllowedException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.uri.ResolvedVariables;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.URIResolver;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRouter
implements ApiRouter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected AbstractConfiguration config;

    public void start() throws MuleException {
        this.startConfiguration();
        this.config.publishConsoleUrls(this.muleContext.getConfiguration().getWorkingDirectory());
    }

    protected abstract void startConfiguration() throws StartException;

    protected Raml getApi() {
        return this.config.getApi();
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        URIResolver uriResolver;
        URIPattern uriPattern;
        HttpRestRequest request = this.getHttpRestRequest(event);
        String path = request.getResourcePath();
        MuleEvent handled = this.handleEvent(event, path);
        if (handled != null) {
            return handled;
        }
        if (path.equals(this.getApi().getUri()) && ActionType.GET.toString().equals(request.getMethod().toUpperCase()) && request.getAdapter().getAcceptableResponseMediaTypes().contains("application/raml+yaml")) {
            String raml = this.config.getApikitRaml(event);
            event.getMessage().setPayload((Object)raml);
            event.getMessage().setOutboundProperty("Content-Type", (Object)"application/raml+yaml");
            event.getMessage().setOutboundProperty("Content-Length", (Object)raml.length());
            event.getMessage().setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            return event;
        }
        path = path.isEmpty() ? "/" : path;
        try {
            uriPattern = (URIPattern)this.getUriPatternCache().get((Object)path);
            uriResolver = (URIResolver)this.getUriResolverCache().get((Object)path);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MuleRestException) {
                throw (MuleRestException)((Object)e.getCause());
            }
            throw new DefaultMuleException((Throwable)e);
        }
        Resource resource = this.getRoutingTable().get(uriPattern);
        if (resource.getAction(request.getMethod()) == null) {
            throw new MethodNotAllowedException(resource.getUri(), request.getMethod());
        }
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        this.processUriParameters(resolvedVariables, resource, event);
        Flow flow = this.getFlow(resource, request.getMethod());
        if (flow == null) {
            throw new ApikitRuntimeException("Flow not found for resource: " + resource);
        }
        return request.process(flow, resource.getAction(request.getMethod()));
    }

    private Map<URIPattern, Resource> getRoutingTable() {
        return this.config.routingTable;
    }

    private LoadingCache<String, URIResolver> getUriResolverCache() {
        return this.config.uriResolverCache;
    }

    private LoadingCache<String, URIPattern> getUriPatternCache() {
        return this.config.uriPatternCache;
    }

    protected abstract MuleEvent handleEvent(MuleEvent var1, String var2) throws MuleException;

    private HttpRestRequest getHttpRestRequest(MuleEvent event) {
        return this.config.getHttpRestRequest(event);
    }

    private void processUriParameters(ResolvedVariables resolvedVariables, Resource resource, MuleEvent event) throws InvalidUriParameterException {
        if (this.logger.isDebugEnabled()) {
            for (String name : resolvedVariables.names()) {
                this.logger.debug("        uri parameter: " + name + "=" + resolvedVariables.get(name));
            }
        }
        if (!this.config.isDisableValidations()) {
            for (String key : resource.getUriParameters().keySet()) {
                String value = (String)resolvedVariables.get(key);
                UriParameter uriParameter = (UriParameter)resource.getUriParameters().get(key);
                if (uriParameter.validate(value)) continue;
                String msg = String.format("Invalid value '%s' for uri parameter %s. %s", value, key, uriParameter.message(value));
                throw new InvalidUriParameterException(msg);
            }
        }
        for (String name : resolvedVariables.names()) {
            event.getMessage().setInvocationProperty(name, resolvedVariables.get(name));
        }
    }

    protected abstract Flow getFlow(Resource var1, String var2);
}

