/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.MalformedURLException;
import java.net.URL;
import org.mule.api.MuleEvent;
import org.mule.module.apikit.exception.ApikitRuntimeException;

public class UrlUtils {
    public static String getBaseSchemeHostPort(MuleEvent event) {
        String scheme;
        String host = (String)event.getMessage().getInboundProperty("host");
        String endpoint = (String)event.getMessage().getInboundProperty("http.context.uri");
        if (endpoint.startsWith("http:")) {
            scheme = "http";
        } else if (endpoint.startsWith("https:")) {
            scheme = "https";
        } else {
            throw new ApikitRuntimeException("Unsupported scheme: " + endpoint);
        }
        return scheme + "://" + host;
    }

    public static String getBaseSchemeHostPort(String baseUri) {
        URL url;
        try {
            url = new URL(baseUri);
        }
        catch (MalformedURLException e) {
            return "http://localhost";
        }
        return url.getProtocol() + "://" + url.getAuthority();
    }
}

