/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.FlowResolver;
import org.mule.module.apikit.HttpRestProxyRequest;
import org.mule.module.apikit.HttpRestRequest;
import org.raml.parser.loader.ClassPathResourceLoader;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;

public class ProxyConfiguration
extends AbstractConfiguration {
    private MessageProcessor chain;

    public void setChain(MessageProcessor chain) {
        this.chain = chain;
    }

    protected void initializeRestFlowMap() {
    }

    protected HttpRestRequest getHttpRestRequest(MuleEvent event) {
        return new HttpRestProxyRequest(event, this);
    }

    protected NodeRuleFactory getValidatorNodeRuleFactory() {
        return new NodeRuleFactory(new NodeRuleFactoryExtension[0]);
    }

    public ResourceLoader getRamlResourceLoader() {
        return new CompositeResourceLoader(new ResourceLoader[]{new RamlUrlResourceLoader(), new ClassPathResourceLoader()});
    }

    protected void initializeRestFlowMapWrapper() {
        if (this.chain != null) {
            super.initializeRestFlowMapWrapper();
        }
    }

    protected FlowResolver getFlowResolver(AbstractConfiguration configuration, String key) {
        return new ProxyFlowResolver((ProxyConfiguration)configuration, key, this.chain);
    }

    static class ProxyFlowResolver
    implements FlowResolver {
        private static final String WRAPPER_FLOW_SUFFIX = "-gateway-wrapper";
        private ProxyConfiguration configuration;
        private String key;
        private MessageProcessor chain;
        private Flow wrapperFlow;

        ProxyFlowResolver(ProxyConfiguration configuration, String key, MessageProcessor chain) {
            this.configuration = configuration;
            this.key = key;
            this.chain = chain;
        }

        public Flow getFlow() {
            if (this.wrapperFlow != null) {
                return this.wrapperFlow;
            }
            this.wrapperFlow = this.wrapFlow();
            return this.wrapperFlow;
        }

        protected Flow getRawFlow() {
            return this.wrapperFlow;
        }

        private Flow wrapFlow() {
            String flowName = this.key + WRAPPER_FLOW_SUFFIX;
            MuleContext muleContext = this.configuration.getMuleContext();
            Flow wrapper = new Flow(flowName, muleContext);
            wrapper.setMessageProcessors(Collections.singletonList(this.chain));
            try {
                muleContext.getRegistry().registerFlowConstruct((FlowConstruct)wrapper);
            }
            catch (MuleException e) {
                throw new RuntimeException("Error registering flow " + flowName, e);
            }
            return wrapper;
        }
    }

    private static class RamlUrlResourceLoader
    implements ResourceLoader {
        private RamlUrlResourceLoader() {
        }

        public InputStream fetchResource(String resourceName) {
            BufferedInputStream inputStream = null;
            try {
                URL url = new URL(resourceName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Accept", "application/raml+yaml, */*");
                inputStream = new BufferedInputStream(connection.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return inputStream;
        }
    }
}

