/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.transform;

import com.google.common.cache.CacheLoader;
import com.sun.xml.bind.api.JAXBRIContext;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.module.apikit.transform.DataTypePair;
import org.mule.module.apikit.transform.TransientAnnotationReader;
import org.mule.module.json.transformers.JsonToObject;
import org.mule.module.json.transformers.ObjectToJson;
import org.mule.module.xml.transformer.jaxb.JAXBMarshallerTransformer;
import org.mule.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerCacheLoader
extends CacheLoader<DataTypePair, Transformer> {
    private static final Logger LOGGER = Logger.getLogger(TransformerCacheLoader.class);
    private final MuleContext muleContext;

    public TransformerCacheLoader(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Transformer load(DataTypePair dataTypePair) throws Exception {
        return this.resolveTransformer(this.muleContext, dataTypePair.getSourceDataType(), dataTypePair.getResultDataType());
    }

    protected Transformer resolveTransformer(MuleContext muleContext, DataType sourceDataType, DataType resultDataType) throws MuleException {
        if (sourceDataType.getMimeType().equals("application/json") || sourceDataType.getMimeType().endsWith("+json")) {
            JsonToObject jto = new JsonToObject();
            jto.setReturnDataType(resultDataType);
            jto.setMapper(new ObjectMapper());
            muleContext.getRegistry().applyProcessorsAndLifecycle((Object)jto);
            return jto;
        }
        if (resultDataType.getMimeType().equals("application/json") || resultDataType.getMimeType().endsWith("+json")) {
            ObjectToJson otj = new ObjectToJson();
            otj.setSourceClass(sourceDataType.getType());
            otj.setReturnDataType(resultDataType);
            otj.setMapper(new ObjectMapper());
            muleContext.getRegistry().applyProcessorsAndLifecycle((Object)otj);
            return otj;
        }
        if (sourceDataType.getMimeType().equals("text/xml") || sourceDataType.getMimeType().endsWith("+xml")) {
            try {
                JAXBUnmarshallerTransformer jmt = new JAXBUnmarshallerTransformer(JAXBContext.newInstance((Class[])new Class[]{resultDataType.getType()}), resultDataType);
                muleContext.getRegistry().applyProcessorsAndLifecycle((Object)jmt);
                return jmt;
            }
            catch (JAXBException e) {
                LOGGER.error((Object)("Unable to create JAXB unmarshaller for " + resultDataType), (Throwable)e);
            }
        } else if (resultDataType.getMimeType().equals("text/xml") || resultDataType.getMimeType().endsWith("+xml")) {
            try {
                TransientAnnotationReader reader = new TransientAnnotationReader();
                reader.addTransientField(Throwable.class.getDeclaredField("stackTrace"));
                reader.addTransientMethod(Throwable.class.getDeclaredMethod("getStackTrace", new Class[0]));
                HashMap<String, TransientAnnotationReader> jaxbConfig = new HashMap<String, TransientAnnotationReader>();
                jaxbConfig.put(JAXBRIContext.ANNOTATION_READER, reader);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{sourceDataType.getType()}, jaxbConfig);
                JAXBMarshallerTransformer jut = new JAXBMarshallerTransformer(jaxbContext, resultDataType);
                jut.setSourceClass(sourceDataType.getType());
                muleContext.getRegistry().applyProcessorsAndLifecycle((Object)jut);
                return jut;
            }
            catch (JAXBException e) {
                LOGGER.error((Object)("Unable to create JAXB marshaller for " + resultDataType), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error((Object)("Unable to create JAXB marshaller for " + resultDataType), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                LOGGER.error((Object)("Unable to create JAXB marshaller for " + resultDataType), (Throwable)e);
            }
        }
        return muleContext.getRegistry().lookupTransformer(sourceDataType, resultDataType);
    }
}

