/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRestSchemaValidator;
import org.mule.module.apikit.validation.cache.XmlSchemaCache;
import org.mule.util.IOUtils;
import org.raml.model.Raml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestXmlSchemaValidator
extends AbstractRestSchemaValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RestXmlSchemaValidator(MuleContext muleContext) {
        super(muleContext);
    }

    public void validate(String configId, String schemaPath, MuleEvent muleEvent, Raml api) throws BadRequestException {
        try {
            Document data;
            Object input = muleEvent.getMessage().getPayload();
            if (input instanceof InputStream) {
                input = IOUtils.toString((InputStream)((InputStream)input));
                this.logger.debug("transforming payload to perform XSD validation");
                muleEvent.getMessage().setPayload(input);
            }
            if (input instanceof String) {
                data = RestXmlSchemaValidator.loadDocument(IOUtils.toInputStream((String)((String)input)));
            } else if (input instanceof byte[]) {
                data = RestXmlSchemaValidator.loadDocument(new ByteArrayInputStream((byte[])input));
            } else {
                throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
            }
            Schema schema = (Schema)XmlSchemaCache.getXmlSchemaCache(this.muleContext, configId, api).get((Object)schemaPath);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(data.getDocumentElement()));
        }
        catch (Exception e) {
            this.logger.info("Schema validation failed: " + e.getMessage());
            throw new BadRequestException(e);
        }
    }

    public static Document loadDocument(InputStream inputStream) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("An internal operation failed.", e);
        }
        catch (SAXException e) {
            throw new IOException("An internal operation failed.", e);
        }
    }
}

