/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.AbstractRouter;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.module.apikit.HttpRestRequest;
import org.raml.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
extends AbstractRouter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConsoleHandler consoleHandler;

    public Configuration getConfig() {
        return (Configuration)this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    protected void startConfiguration() throws StartException {
        if (this.config == null) {
            try {
                this.config = (AbstractConfiguration)this.muleContext.getRegistry().lookupObject(Configuration.class);
            }
            catch (RegistrationException e) {
                throw new StartException(MessageFactory.createStaticMessage((String)"APIKit configuration not Found"), (Startable)this);
            }
        }
        this.config.loadApiDefinition(this.flowConstruct);
        if (this.getConfig().isConsoleEnabled()) {
            this.consoleHandler = new ConsoleHandler(this.getApi().getBaseUri(), this.getConfig().getConsolePath());
            this.getConfig().addConsoleUrl(this.consoleHandler.getConsoleUrl());
        }
    }

    protected MuleEvent handleEvent(MuleEvent event, String path) throws MuleException {
        if (this.getConfig().isConsoleEnabled() && path.startsWith(this.getApi().getUri() + "/" + this.getConfig().getConsolePath())) {
            return this.consoleHandler.process(event);
        }
        return null;
    }

    protected Flow getFlow(Resource resource, HttpRestRequest request) {
        String baseKey = request.getMethod() + ":" + resource.getUri();
        String contentType = request.getContentType();
        Map<String, Flow> rawRestFlowMap = ((Configuration)this.config).getRawRestFlowMap();
        Flow flow = rawRestFlowMap.get(baseKey + ":" + contentType);
        if (flow == null) {
            flow = rawRestFlowMap.get(baseKey);
        }
        return flow;
    }
}

