/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class PatternKeywordValidator
extends KeywordValidator {
    private final String regex;

    public PatternKeywordValidator(JsonNode schema) {
        super("pattern", NodeType.STRING);
        this.regex = schema.get(this.keyword).textValue();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (RhinoHelper.regMatch(this.regex, instance.textValue())) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("regex", this.regex).addInfo("string", instance).setMessage("ECMA 262 regex does not match input string");
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.regex;
    }
}

