/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingExceptionListener
extends CatchMessagingExceptionStrategy {
    private int statusCode;
    private List<Class<?>> exceptions = new ArrayList();

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setExceptions(List<String> exceptions) {
        for (String exception : exceptions) {
            try {
                this.exceptions.add(ClassUtils.getClass((String)exception));
            }
            catch (ClassNotFoundException e) {
                throw new ApikitRuntimeException(e);
            }
        }
    }

    public boolean accept(MuleEvent event) {
        IdentityHashMap visited = new IdentityHashMap();
        for (Throwable exception = event.getMessage().getExceptionPayload().getException(); exception != null && !visited.containsKey(exception); exception = exception.getCause()) {
            for (Class<?> declared : this.exceptions) {
                if (!declared.isAssignableFrom(exception.getClass())) continue;
                return true;
            }
            visited.put(exception, null);
        }
        return false;
    }

    protected MuleEvent afterRouting(Exception exception, MuleEvent event) {
        event.getMessage().setOutboundProperty("http.status", (Object)this.statusCode);
        return event;
    }

    public String toString() {
        return "MappingExceptionListener{statusCode=" + this.statusCode + ", exceptions=" + this.exceptions + '}';
    }
}

