/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.apikit.UrlUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProtocolAdapter {
    private String basePath;
    private URI resourceURI;
    private String method;
    private String acceptableResponseMediaTypes;
    private String requestMediaType;
    private Map<String, Object> queryParams;

    public HttpProtocolAdapter(MuleEvent event) {
        MuleMessage message = event.getMessage();
        this.basePath = UrlUtils.getBasePath(message);
        String hostHeader = (String)message.getInboundProperty("host");
        if (hostHeader == null) {
            throw new IllegalArgumentException("host header cannot be null");
        }
        String host = hostHeader;
        int port = 80;
        String requestPath = (String)message.getInboundProperty("http.request.path");
        if (hostHeader.contains(":")) {
            host = hostHeader.substring(0, hostHeader.indexOf(58));
            port = Integer.parseInt(hostHeader.substring(hostHeader.indexOf(58) + 1));
        }
        try {
            this.resourceURI = new URI("http", null, host, port, requestPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot parse URI", e);
        }
        this.method = (String)message.getInboundProperty("http.method");
        if (!StringUtils.isBlank((String)((String)message.getInboundProperty("accept")))) {
            this.acceptableResponseMediaTypes = (String)message.getInboundProperty("accept");
        }
        if (!StringUtils.isBlank((String)((String)message.getInboundProperty("content-type")))) {
            this.requestMediaType = (String)message.getInboundProperty("content-type");
        }
        if (this.requestMediaType == null && !StringUtils.isBlank((String)((String)message.getOutboundProperty("content-type")))) {
            this.requestMediaType = (String)message.getOutboundProperty("content-type");
        }
        this.queryParams = (Map)message.getInboundProperty("http.query.params");
    }

    public String getBasePath() {
        return this.basePath;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAcceptableResponseMediaTypes() {
        if (this.acceptableResponseMediaTypes == null) {
            return "*/*";
        }
        return this.acceptableResponseMediaTypes;
    }

    public String getRequestMediaType() {
        return this.requestMediaType != null ? this.requestMediaType.split(";")[0] : null;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }
}

