/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cors;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.callback.SourceCallback;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.modules.cors.Origin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSModule {
    private static final Logger logger = LoggerFactory.getLogger(CORSModule.class);
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private MuleContext muleContext;
    private String storePrefix = "_corsModule";
    private List<Origin> origins;
    private ObjectStore<Origin> originsStore;

    public void initializeModule() throws ObjectStoreException {
        boolean newObjectStore = false;
        if (this.originsStore == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No object store configured, defaulting to CORSOriginsStore");
            }
            String appName = this.muleContext.getConfiguration().getId();
            this.originsStore = this.objectStoreManager.getObjectStore(appName + "CORSOriginsStore" + this.storePrefix);
            newObjectStore = true;
        }
        if (this.origins == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No initial set of origins configured.");
            }
            return;
        }
        for (Origin o : this.origins) {
            if (logger.isDebugEnabled()) {
                logger.debug("Configuring origin: " + o.getUrl());
            }
            if (this.originsStore.contains((Serializable)((Object)o.getUrl()))) {
                if (newObjectStore) {
                    this.originsStore.remove((Serializable)((Object)o.getUrl()));
                } else {
                    logger.warn("Object Store already contains " + o.getUrl());
                    continue;
                }
            }
            this.originsStore.store((Serializable)((Object)o.getUrl()), (Serializable)o);
        }
    }

    public void doClearModule() {
        this.originsStore = null;
    }

    @Inject
    public MuleEvent validate(SourceCallback callback, MuleEvent event, boolean publicResource, boolean acceptsCredentials) throws Exception {
        if (publicResource && acceptsCredentials) {
            throw new IllegalArgumentException("Resource may not be public and accept credentials at the same time");
        }
        MuleMessage message = event.getMessage();
        String origin = (String)message.getInboundProperty("Origin");
        if (StringUtils.isEmpty((String)origin)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request is not a CORS request.");
            }
            return callback.processEvent(event);
        }
        String method = (String)message.getInboundProperty("http.method");
        String requestMethod = (String)message.getInboundProperty("Access-Control-Request-Method");
        String requestHeaders = (String)message.getInboundProperty("Access-Control-Request-Headers");
        MuleEvent result = event;
        if (this.shouldInvokeFlow(origin, method, publicResource)) {
            result = callback.processEvent(result);
        } else {
            result.getMessage().setPayload(null);
        }
        this.configureCorsHeaders(result.getMessage(), method, origin, requestMethod, requestHeaders, publicResource, acceptsCredentials);
        return result;
    }

    private void configureCorsHeaders(MuleMessage message, String method, String origin, String requestMethod, String requestHeaders, boolean publicResource, boolean acceptsCredentials) throws ObjectStoreException {
        String checkMethod;
        boolean isPreflight = StringUtils.equals((String)"OPTIONS", (String)method);
        if (publicResource) {
            message.setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            if (isPreflight) {
                message.setOutboundProperty("Access-Control-Allow-Methods", (Object)requestMethod);
                message.setOutboundProperty("Access-Control-Allow-Headers", (Object)requestHeaders);
            }
            return;
        }
        Origin configuredOrigin = this.findOrigin(origin);
        if (configuredOrigin == null) {
            return;
        }
        String string = checkMethod = isPreflight ? requestMethod : method;
        if (configuredOrigin.getMethods() == null || !configuredOrigin.getMethods().contains(checkMethod)) {
            return;
        }
        message.setOutboundProperty("Access-Control-Allow-Origin", (Object)origin);
        if (acceptsCredentials) {
            message.setOutboundProperty("Access-Control-Allow-Credentials", (Object)"true");
        }
        if (!isPreflight) {
            return;
        }
        if (configuredOrigin.getMethods() != null) {
            message.setOutboundProperty("Access-Control-Allow-Methods", (Object)StringUtils.join(configuredOrigin.getMethods(), (String)", "));
        }
        if (configuredOrigin.getHeaders() != null) {
            message.setOutboundProperty("Access-Control-Allow-Headers", (Object)StringUtils.join(configuredOrigin.getHeaders(), (String)", "));
        }
        if (configuredOrigin.getExposeHeaders() != null) {
            message.setOutboundProperty("Access-Control-Expose-Headers", (Object)StringUtils.join(configuredOrigin.getExposeHeaders(), (String)", "));
        }
        if (configuredOrigin.getAccessControlMaxAge() != null) {
            message.setOutboundProperty("Access-Control-Max-Age", (Object)configuredOrigin.getAccessControlMaxAge());
        }
    }

    private boolean shouldInvokeFlow(String origin, String method, boolean publicResource) throws ObjectStoreException {
        if (StringUtils.equals((String)"OPTIONS", (String)method)) {
            if (logger.isDebugEnabled()) {
                logger.debug("OPTIONS header, will not continue processing.");
            }
            return false;
        }
        if (publicResource) {
            return true;
        }
        Origin configuredOrigin = this.findOrigin(origin);
        if (configuredOrigin == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not find configuration for origin: " + origin);
            }
            return false;
        }
        if (configuredOrigin.getMethods() != null) {
            return configuredOrigin.getMethods().contains(method);
        }
        logger.warn("Configured origin has no methods. Not allowing the execution of the flow");
        return false;
    }

    private Origin findOrigin(String origin) throws ObjectStoreException {
        if (!this.originsStore.contains((Serializable)((Object)origin))) {
            if (!this.originsStore.contains((Serializable)((Object)"*"))) {
                return null;
            }
            return (Origin)this.originsStore.retrieve((Serializable)((Object)"*"));
        }
        return (Origin)this.originsStore.retrieve((Serializable)((Object)origin));
    }

    public ObjectStore<Origin> getOriginsStore() {
        return this.originsStore;
    }

    public void setOriginsStore(ObjectStore<Origin> originsStore) {
        this.originsStore = originsStore;
    }

    public List<Origin> getOrigins() {
        return this.origins;
    }

    public void setOrigins(List<Origin> origins) {
        this.origins = origins;
    }

    public ObjectStoreManager getObjectStoreManager() {
        return this.objectStoreManager;
    }

    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String getStorePrefix() {
        return this.storePrefix;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }
}

