/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cors;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReplyToHandler;
import org.mule.modules.cors.CorsConfig;
import org.mule.modules.cors.Origin;
import org.mule.processor.AbstractRequestResponseMessageProcessor;

public class ValidateMessageProcessor
extends AbstractRequestResponseMessageProcessor {
    private static final String STOP_PROCESSING_FLAG = "MULE___stopProcessing";
    private boolean publicResource;
    private boolean acceptsCredentials;
    private CorsConfig config;

    protected MuleEvent processRequest(MuleEvent event) throws MuleException {
        if (this.publicResource && this.acceptsCredentials) {
            throw new IllegalArgumentException("Resource may not be public and accept credentials at the same time");
        }
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        if (StringUtils.isEmpty((String)origin)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request is not a CORS request.");
            }
            return event;
        }
        String method = (String)event.getMessage().getInboundProperty("http.method");
        if (this.shouldInvokeFlow(origin, method, this.publicResource)) {
            return event;
        }
        event.getMessage().setPayload(null);
        event.getMessage().setInvocationProperty(STOP_PROCESSING_FLAG, (Object)true);
        return event;
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (event != null && !VoidMuleEvent.getInstance().equals(event) && Boolean.TRUE.equals(event.getMessage().getInvocationProperty(STOP_PROCESSING_FLAG))) {
            event.getMessage().removeProperty(STOP_PROCESSING_FLAG, PropertyScope.INVOCATION);
            return event;
        }
        return super.processNext(event);
    }

    protected MuleEvent processResponse(String origin, String method, String requestMethod, String requestHeaders, MuleEvent event) throws MuleException {
        String checkMethod;
        MuleMessage message = event.getMessage();
        if (StringUtils.isEmpty((String)origin)) {
            return event;
        }
        boolean isPreflight = StringUtils.equals((String)"OPTIONS", (String)method);
        if (this.publicResource) {
            message.setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
            if (isPreflight) {
                if (requestMethod != null) {
                    message.setOutboundProperty("Access-Control-Allow-Methods", (Object)requestMethod);
                }
                if (requestHeaders != null) {
                    message.setOutboundProperty("Access-Control-Allow-Headers", (Object)requestHeaders);
                }
            }
            return event;
        }
        Origin configuredOrigin = this.findOrigin(origin);
        if (configuredOrigin == null) {
            return event;
        }
        String string = checkMethod = isPreflight ? requestMethod : method;
        if (configuredOrigin.getMethods() == null || !configuredOrigin.getMethods().contains(checkMethod)) {
            return event;
        }
        message.setOutboundProperty("Access-Control-Allow-Origin", (Object)origin);
        if (this.acceptsCredentials) {
            message.setOutboundProperty("Access-Control-Allow-Credentials", (Object)"true");
        }
        if (!isPreflight) {
            return event;
        }
        if (configuredOrigin.getMethods() != null) {
            message.setOutboundProperty("Access-Control-Allow-Methods", (Object)StringUtils.join(configuredOrigin.getMethods(), (String)", "));
        }
        if (configuredOrigin.getHeaders() != null) {
            message.setOutboundProperty("Access-Control-Allow-Headers", (Object)StringUtils.join(configuredOrigin.getHeaders(), (String)", "));
        }
        if (configuredOrigin.getExposeHeaders() != null) {
            message.setOutboundProperty("Access-Control-Expose-Headers", (Object)StringUtils.join(configuredOrigin.getExposeHeaders(), (String)", "));
        }
        if (configuredOrigin.getAccessControlMaxAge() != null) {
            message.setOutboundProperty("Access-Control-Max-Age", (Object)configuredOrigin.getAccessControlMaxAge());
        }
        return event;
    }

    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        MessagingException exception = null;
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        String method = (String)event.getMessage().getInboundProperty("http.method");
        String requestMethod = (String)event.getMessage().getInboundProperty("Access-Control-Request-Method");
        String requestHeaders = (String)event.getMessage().getInboundProperty("Access-Control-Request-Headers");
        try {
            MuleEvent muleEvent = this.processResponse(origin, method, requestMethod, requestHeaders, this.processNext(this.processRequest(event)));
            return muleEvent;
        }
        catch (MessagingException e) {
            exception = e;
            throw e;
        }
        finally {
            this.processFinally(event, exception);
        }
    }

    protected MuleEvent processNonBlocking(MuleEvent event) throws MuleException {
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        String method = (String)event.getMessage().getInboundProperty("http.method");
        String requestMethod = (String)event.getMessage().getInboundProperty("Access-Control-Request-Method");
        String requestHeaders = (String)event.getMessage().getInboundProperty("Access-Control-Request-Headers");
        CorsReplyToHandler corsReplyToHandler = new CorsReplyToHandler(event.getReplyToHandler(), origin, method, requestMethod, requestHeaders);
        event = new DefaultMuleEvent(event, (ReplyToHandler)corsReplyToHandler);
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
        try {
            MuleEvent result = this.processNext(this.processRequest(event));
            if (!(result instanceof NonBlockingVoidMuleEvent)) {
                return this.processResponse(origin, method, requestMethod, requestHeaders, result);
            }
            return result;
        }
        catch (MessagingException exception) {
            this.processFinally(event, exception);
            throw exception;
        }
    }

    private boolean shouldInvokeFlow(String origin, String method, boolean publicResource) throws ObjectStoreException {
        if (StringUtils.equals((String)"OPTIONS", (String)method)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"OPTIONS header, will not continue processing.");
            }
            return false;
        }
        if (publicResource) {
            return true;
        }
        Origin configuredOrigin = this.findOrigin(origin);
        if (configuredOrigin == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not find configuration for origin: " + origin));
            }
            return false;
        }
        if (configuredOrigin.getMethods() != null) {
            return configuredOrigin.getMethods().contains(method);
        }
        this.logger.warn((Object)"Configured origin has no methods. Not allowing the execution of the flow");
        return false;
    }

    private Origin findOrigin(String origin) throws ObjectStoreException {
        if (!this.config.getOriginsStore().contains((Serializable)((Object)origin))) {
            if (!this.config.getOriginsStore().contains((Serializable)((Object)"*"))) {
                return null;
            }
            return (Origin)this.config.getOriginsStore().retrieve((Serializable)((Object)"*"));
        }
        return (Origin)this.config.getOriginsStore().retrieve((Serializable)((Object)origin));
    }

    public void setPublicResource(boolean publicResource) {
        this.publicResource = publicResource;
    }

    public void setAcceptsCredentials(boolean acceptsCredentials) {
        this.acceptsCredentials = acceptsCredentials;
    }

    public void setConfig(CorsConfig config) {
        this.config = config;
    }

    class CorsReplyToHandler
    implements ReplyToHandler {
        private final String origin;
        private final String method;
        private final String requestMethod;
        private final String requestHeaders;
        private final ReplyToHandler originalReplyToHandler;

        public CorsReplyToHandler(ReplyToHandler originalReplyToHandler, String origin, String method, String requestMethod, String requestHeaders) {
            this.originalReplyToHandler = originalReplyToHandler;
            this.origin = origin;
            this.method = method;
            this.requestMethod = requestMethod;
            this.requestHeaders = requestHeaders;
        }

        public void processReplyTo(MuleEvent event, MuleMessage muleMessage, Object replyTo) throws MuleException {
            MuleEvent response = ValidateMessageProcessor.this.processResponse(this.origin, this.method, this.requestMethod, this.requestHeaders, (MuleEvent)new DefaultMuleEvent(event, this.originalReplyToHandler));
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)response);
            if (!NonBlockingVoidMuleEvent.getInstance().equals(response)) {
                this.originalReplyToHandler.processReplyTo(response, null, null);
            }
            ValidateMessageProcessor.this.processFinally(event, null);
        }

        public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
            this.originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
            ValidateMessageProcessor.this.processFinally(exception.getEvent(), exception);
        }
    }
}

