/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cors.model;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.modules.cors.model.Origin;

public class CorsConfig
implements Initialisable,
Stoppable,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String storePrefix;
    private List<Origin> origins;
    private ObjectStore<Origin> originsStore;
    private MuleContext muleContext;

    public Origin findOrigin(String origin) {
        try {
            if (!this.getOriginsStore().contains((Serializable)((Object)origin))) {
                if (!this.getOriginsStore().contains((Serializable)((Object)"*"))) {
                    return null;
                }
                return (Origin)this.getOriginsStore().retrieve((Serializable)((Object)"*"));
            }
            return (Origin)this.getOriginsStore().retrieve((Serializable)((Object)origin));
        }
        catch (ObjectStoreException ose) {
            this.logger.warn((Object)("Error searching origin " + origin + " in object store. Error: " + ose.getMessage()));
            return null;
        }
    }

    public void initialise() throws InitialisationException {
        boolean newObjectStore = false;
        if (this.originsStore == null) {
            String appName = this.muleContext.getConfiguration().getId();
            this.originsStore = this.muleContext.getObjectStoreManager().getObjectStore((String)appName + "CORSOriginsStore" + this.storePrefix);
            newObjectStore = true;
        }
        if (this.origins == null) {
            return;
        }
        try {
            for (Origin o : this.origins) {
                if (this.originsStore.contains((Serializable)((Object)o.getUrl()))) {
                    if (!newObjectStore) continue;
                    this.originsStore.remove((Serializable)((Object)o.getUrl()));
                }
                this.originsStore.store((Serializable)((Object)o.getUrl()), (Serializable)o);
            }
        }
        catch (ObjectStoreException ose) {
            throw new InitialisationException((Throwable)ose, (Initialisable)this);
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void stop() throws MuleException {
        this.muleContext.getObjectStoreManager().disposeStore(this.originsStore);
        this.originsStore = null;
    }

    public String getStorePrefix() {
        return this.storePrefix;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }

    public List<Origin> getOrigins() {
        return this.origins;
    }

    public void setOrigins(List<Origin> origins) {
        this.origins = origins;
    }

    public ObjectStore<Origin> getOriginsStore() {
        return this.originsStore;
    }

    public void setOriginsStore(ObjectStore<Origin> originsStore) {
        this.originsStore = originsStore;
    }
}

