/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.mule.security.oauth.util.HttpUtil;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtilImpl
implements HttpUtil {
    private static final transient Logger logger = LoggerFactory.getLogger(HttpUtilImpl.class);

    @Override
    public String post(String url, String body) {
        int responseCode;
        InputStream errorStream;
        OutputStreamWriter out;
        HttpURLConnection conn;
        block11: {
            conn = null;
            try {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(url + " is not a valid url", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open connection to " + url, e);
            }
            try {
                conn.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new RuntimeException("Something is wrong with the runtime, POST is not recognized as a verb", e);
            }
            conn.setDoOutput(true);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Sending request to [%s] using the following as content [%s]", url, body));
            }
            out = null;
            errorStream = null;
            out = new OutputStreamWriter(conn.getOutputStream());
            out.write(body);
            out.flush();
            responseCode = conn.getResponseCode();
            if (!this.wasSuccessful(responseCode)) break block11;
            String string = IOUtils.toString((InputStream)conn.getInputStream());
            IOUtils.closeQuietly((Writer)out);
            IOUtils.closeQuietly((InputStream)errorStream);
            return string;
        }
        try {
            try {
                errorStream = conn.getErrorStream();
                String response = IOUtils.toString((InputStream)errorStream);
                String errorMsg = String.format("Received status code [%d] while trying to get OAuth2 verification code. Response body was [%s]", responseCode, response);
                logger.error(errorMsg);
                throw new IOException(errorMsg);
            }
            catch (IOException e) {
                throw new RuntimeException("Error found while consuming http resource at " + url, e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(errorStream);
            throw throwable;
        }
    }

    private boolean wasSuccessful(int responseCode) throws IOException {
        return responseCode >= 200 && responseCode <= 203;
    }
}

