/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.transform;

import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.transform.DataTypePair;
import org.mule.module.apikit.transform.TransformerCache;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.raml.model.MimeType;

public class ApikitResponseTransformer
extends AbstractMessageTransformer {
    public static final String BEST_MATCH_REPRESENTATION = "_ApikitResponseTransformer_bestMatchRepresentation";
    public static final String CONTRACT_MIME_TYPES = "_ApikitResponseTransformer_contractMimeTypes";
    public static final String APIKIT_ROUTER_REQUEST = "_ApikitResponseTransformer_apikitRouterRequest";

    public Object transformMessage(MuleMessage message, String encoding) throws TransformerException {
        if (message.getInvocationProperty(APIKIT_ROUTER_REQUEST) == null) {
            return message;
        }
        String responseRepresentation = (String)message.getInvocationProperty(BEST_MATCH_REPRESENTATION);
        List responseMimeTypes = (List)message.getInvocationProperty(CONTRACT_MIME_TYPES);
        if (responseRepresentation == null) {
            if (message.getOutboundProperty("http.status") == null) {
                message.setPayload((Object)NullPayload.getInstance());
            }
            return message;
        }
        return this.transformToExpectedContentType(message, responseRepresentation, responseMimeTypes);
    }

    public Object transformToExpectedContentType(MuleMessage message, String responseRepresentation, List<MimeType> responseMimeTypes) throws TransformerException {
        Object payload = message.getPayload();
        String msgMimeType = null;
        DataType dataType = message.getDataType();
        if (dataType != null && dataType.getMimeType() != null) {
            msgMimeType = dataType.getMimeType() + ";charset=" + message.getEncoding();
        }
        String msgContentType = (String)message.getOutboundProperty("Content-Type");
        if ("*/*".equals(responseRepresentation)) {
            if (msgContentType == null) {
                throw new ApikitRuntimeException("Content-Type must be set in the flow when declaring */* response type");
            }
            return payload;
        }
        if (payload instanceof NullPayload) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Response transformation not required. Message payload type is NullPayload");
            }
            return payload;
        }
        String msgAcceptedContentType = this.acceptedContentType(msgMimeType, msgContentType, responseMimeTypes);
        if (msgAcceptedContentType != null) {
            message.setOutboundProperty("Content-Type", (Object)msgAcceptedContentType);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Response transformation not required. Message payload type is " + msgAcceptedContentType));
            }
            return payload;
        }
        DataType sourceDataType = DataTypeFactory.create(message.getPayload().getClass(), (String)msgMimeType);
        DataType resultDataType = DataTypeFactory.create(String.class, (String)responseRepresentation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Resolving transformer between [source=%s] and [result=%s]", sourceDataType, resultDataType));
        }
        try {
            Transformer transformer = (Transformer)TransformerCache.getTransformerCache(this.muleContext).get((Object)new DataTypePair(sourceDataType, resultDataType));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Transformer resolved to [transformer=%s]", transformer));
            }
            Object newPayload = transformer.transform(message.getPayload());
            message.setOutboundProperty("Content-Type", (Object)responseRepresentation);
            return newPayload;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    private String acceptedContentType(String msgMimeType, String msgContentType, List<MimeType> responseMimeTypes) {
        for (MimeType responseMimeType : responseMimeTypes) {
            if (msgMimeType != null && msgMimeType.contains(responseMimeType.getType())) {
                return msgMimeType;
            }
            if (msgContentType == null || !msgContentType.contains(responseMimeType.getType())) continue;
            return msgContentType;
        }
        return null;
    }
}

